/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.integrations.patchouli.ProductiveBeesPatchouli;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;

public class BeeReloadListener
extends SimpleJsonResourceReloadListener {
    public static RecipeManager recipeManager;
    private static final Gson GSON;
    public static final BeeReloadListener INSTANCE;
    private Map<String, CompoundTag> BEE_DATA = new HashMap<String, CompoundTag>();

    public BeeReloadListener() {
        super(GSON, "productivebees");
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, @Nonnull ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_6180_("BeeReloadListener");
        HashMap<String, CompoundTag> data = new HashMap<String, CompoundTag>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : dataMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                if (!CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions")) {
                    ProductiveBees.LOGGER.debug("Skipping loading productive bee {} as its conditions were not met", (Object)id);
                    continue;
                }
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.debug("Skipping loading productive bee {} as its conditions were invalid", (Object)id);
                throw e;
            }
            ResourceLocation simpleId = id.m_135815_().contains("/") ? new ResourceLocation(id.m_135827_(), id.m_135815_().substring(id.m_135815_().lastIndexOf("/") + 1)) : id;
            CompoundTag nbt = BeeCreator.create(simpleId, entry.getValue().getAsJsonObject());
            data.remove(simpleId.toString());
            data.put(simpleId.toString(), nbt);
            ProductiveBees.LOGGER.debug("Adding to bee data " + simpleId);
        }
        this.setData(data);
        profiler.m_6182_("BeeReloadListener");
    }

    public CompoundTag getData(String id) {
        return this.BEE_DATA.get(id);
    }

    public Map<String, CompoundTag> getData() {
        return this.BEE_DATA;
    }

    public void setData(Map<String, CompoundTag> data) {
        this.BEE_DATA = data;
        if (ModList.get().isLoaded("patchouli")) {
            ProductiveBeesPatchouli.setBeeFlags();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        INSTANCE = new BeeReloadListener();
    }
}

