/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeEffect;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeCreator {
    public static CompoundTag create(ResourceLocation id, JsonObject json) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("id", id.toString());
        Color primary = Color.decode(json.has("primaryColor") ? json.get("primaryColor").getAsString() : "#edc343");
        Color secondary = Color.decode(json.has("secondaryColor") ? json.get("secondaryColor").getAsString() : "#804f40");
        data.m_128405_("primaryColor", primary.getRGB());
        data.m_128405_("secondaryColor", secondary.getRGB());
        data.m_128359_("name", (String)(json.has("name") ? json.get("name").getAsString() : BeeCreator.idToName(id.m_135815_()) + " Bee"));
        if (json.has("description")) {
            data.m_128359_("description", json.get("description").getAsString());
        }
        if (json.has("flowerTag") && !json.get("flowerTag").getAsString().isEmpty()) {
            data.m_128359_("flowerTag", json.get("flowerTag").getAsString());
        } else if (json.has("flowerBlock") && !json.get("flowerBlock").getAsString().isEmpty()) {
            data.m_128359_("flowerBlock", json.get("flowerBlock").getAsString());
        }
        if (json.has("nestingPreference")) {
            data.m_128359_("nestingPreference", json.get("nestingPreference").getAsString());
        }
        if (json.has("beeTexture")) {
            data.m_128359_("beeTexture", json.get("beeTexture").getAsString());
        }
        if (json.has("combTexture")) {
            data.m_128359_("combTexture", json.get("combTexture").getAsString());
        }
        if (json.has("particleColor")) {
            data.m_128405_("particleColor", Color.decode(json.get("particleColor").getAsString()).getRGB());
        }
        data.m_128405_("tertiaryColor", json.has("tertiaryColor") ? Color.decode(json.get("tertiaryColor").getAsString()).getRGB() : data.m_128451_("primaryColor"));
        if (json.has("attackResponse")) {
            data.m_128359_("attackResponse", json.get("attackResponse").getAsString());
        }
        data.m_128359_("flowerType", json.has("flowerType") ? json.get("flowerType").getAsString() : "block");
        data.m_128359_("renderer", json.has("renderer") ? json.get("renderer").getAsString() : "default");
        data.m_128359_("renderTransform", json.has("renderTransform") ? json.get("renderTransform").getAsString() : "none");
        data.m_128359_("particleType", json.has("particleType") ? json.get("particleType").getAsString() : "drip");
        data.m_128350_("size", json.has("size") ? json.get("size").getAsFloat() : 1.0f);
        data.m_128379_("translucent", json.has("translucent") && json.get("translucent").getAsBoolean() || data.m_128461_("renderer").equals("translucent_with_center"));
        data.m_128379_("useGlowLayer", !json.has("useGlowLayer") || json.get("useGlowLayer").getAsBoolean());
        data.m_128379_("fireproof", json.has("fireproof") && json.get("fireproof").getAsBoolean());
        data.m_128379_("withered", json.has("withered") && json.get("withered").getAsBoolean());
        data.m_128379_("blinding", json.has("blinding") && json.get("blinding").getAsBoolean());
        data.m_128379_("draconic", json.has("draconic") && json.get("draconic").getAsBoolean());
        data.m_128379_("slimy", json.has("slimy") && json.get("slimy").getAsBoolean());
        data.m_128379_("teleporting", json.has("teleporting") && json.get("teleporting").getAsBoolean());
        data.m_128379_("munchies", json.has("munchies") && json.get("munchies").getAsBoolean());
        data.m_128379_("redstoned", json.has("redstoned") && json.get("redstoned").getAsBoolean());
        data.m_128379_("stringy", json.has("stringy") && json.get("stringy").getAsBoolean());
        data.m_128379_("stingless", json.has("stingless") && json.get("stingless").getAsBoolean());
        data.m_128379_("waterproof", json.has("waterproof") && json.get("waterproof").getAsBoolean());
        data.m_128379_("selfbreed", !json.has("selfbreed") || json.get("selfbreed").getAsBoolean());
        if (json.has("attributes")) {
            for (Map.Entry entry : json.get("attributes").getAsJsonObject().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "productivity": 
                    case "endurance": 
                    case "temper": 
                    case "behavior": 
                    case "weather_tolerance": {
                        data.m_128405_((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
            }
        }
        if (json.has("passiveEffects")) {
            HashMap<MobEffect, Integer> effects = new HashMap<MobEffect, Integer>();
            for (JsonElement el : json.get("passiveEffects").getAsJsonArray()) {
                JsonObject effect = el.getAsJsonObject();
                effects.put((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect.get("effect").getAsString())), effect.get("duration").getAsInt());
            }
            data.m_128365_("effect", (Tag)new BeeEffect(effects).serializeNBT());
        }
        data.m_128379_("createComb", !json.has("createComb") || json.get("createComb").getAsBoolean());
        return data;
    }

    public static String idToName(String givenString) {
        String[] arr = givenString.replace("_", " ").split(" ");
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static void setTag(String type, ItemStack stack) {
        CompoundTag tag = stack.m_41698_("EntityTag");
        tag.m_128359_("type", type);
    }

    public static ItemStack getSpawnEgg(String beeType) {
        ItemStack egg;
        if (BeeReloadListener.INSTANCE.getData(beeType) != null) {
            egg = new ItemStack((ItemLike)ModItems.CONFIGURABLE_SPAWN_EGG.get());
            BeeCreator.setTag(beeType, egg);
        } else {
            ResourceLocation name = new ResourceLocation(beeType);
            egg = name.m_135827_().equals("productivebees") ? new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.m_135827_(), "spawn_egg_" + name.m_135815_()))) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.m_135827_(), name.m_135815_() + "_spawn_egg")));
        }
        return egg;
    }
}

