/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.randommobeffects.util;

import com.natamus.collective.data.GlobalVariables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Util {
    private static List<String> defaultblacklist = new ArrayList<String>(Arrays.asList("minecraft:instant_health", "minecraft:instant_damage", "minecraft:invisibility", "minecraft:wither", "minecraft:glowing", "minecraft:levitation", "minecraft:bad_omen", "minecraft:hero_of_the_village"));
    private static List<Potion> potioneffects = new ArrayList<Potion>();
    private static String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "randommobeffects";
    private static File dir = new File(dirpath);
    private static File file = new File(dirpath + File.separator + "blacklist.txt");

    public static boolean setupPotionEffects() throws IOException, FileNotFoundException, UnsupportedEncodingException {
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !file.isFile()) {
            dir.mkdirs();
            writer = new PrintWriter(dirpath + File.separator + "blacklist.txt", "UTF-8");
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "blacklist.txt", new String[0])));
            for (String effectrl : blcontent.split(",")) {
                String name = effectrl.replace("\n", "").trim();
                if (!name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        for (Potion effect : ForgeRegistries.POTIONS) {
            ResourceLocation rl = effect.getRegistryName();
            if (rl == null) continue;
            String name = rl.toString();
            if (writer != null) {
                String towrite = name + ",";
                if (defaultblacklist.contains(name)) {
                    blacklist.add(name);
                    towrite = "!" + towrite;
                }
                writer.println(towrite);
            }
            if (blacklist.contains(name)) continue;
            potioneffects.add(effect);
        }
        if (writer != null) {
            writer.close();
        }
        return potioneffects.size() > 0;
    }

    public static Potion getRandomEffect() {
        int i = GlobalVariables.random.nextInt(potioneffects.size());
        return potioneffects.get(i);
    }
}

