/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.harvest;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import info.tehnut.harvest.Harvest;
import info.tehnut.harvest.RegistryWaiter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

@JsonAdapter(value=Adapter.class)
public class Crop
implements Predicate<class_2680> {
    private class_2680 mature;
    private class_2248 block;

    public Crop(class_2960 name, JsonObject states) {
        RegistryWaiter.waitFor(blocks -> {
            class_2248 block = (class_2248)blocks.apply(name);
            this.setMature(block, states);
        }, (id, replacement) -> this.setMature((class_2248)replacement, states), class_2378.field_11146, new class_2960[]{name});
    }

    public Crop(class_2680 state) {
        this.mature = state;
    }

    private void setMature(class_2248 block, JsonObject states) {
        class_2680 state = block.method_9564();
        for (Map.Entry e : states.entrySet()) {
            class_2769 property = block.method_9595().method_11663((String)e.getKey());
            if (property == null) continue;
            String valueString = ((JsonElement)e.getValue()).getAsString();
            Comparable value = (Comparable)property.method_11900(valueString).get();
            state = (class_2680)state.method_11657(property, value);
        }
        this.mature = state;
        Harvest.debug("Registered crop " + this + " from config", new Object[0]);
    }

    public class_2680 getMature() {
        return this.mature;
    }

    public class_2248 getBlock() {
        return this.block == null ? (this.block = this.mature.method_26204()) : this.block;
    }

    @Override
    public boolean test(class_2680 state) {
        return state == this.mature;
    }

    public String toString() {
        if (this.mature != null) {
            return "Crop{" + this.mature + "}";
        }
        return "Crop{null}";
    }

    public static class Adapter
    implements JsonSerializer<Crop>,
    JsonDeserializer<Crop> {
        public Crop deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            class_2960 blockID = new class_2960(json.getAsJsonPrimitive("block").getAsString());
            JsonObject stateObject = json.getAsJsonObject("states");
            return new Crop(blockID, stateObject);
        }

        public JsonElement serialize(Crop src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("block", class_2378.field_11146.method_10221((Object)src.getBlock()).toString());
            String stateString = src.mature.toString();
            String[] properties = stateString.substring(stateString.indexOf("[") + 1, stateString.length() - 1).split(",");
            JsonObject states = new JsonObject();
            for (String property : properties) {
                String[] split = property.split("=");
                states.addProperty(split[0], split[1]);
            }
            object.add("states", (JsonElement)states);
            return object;
        }
    }
}

