/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.harvest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RegistryWaiter<T>
implements RegistryEntryAddedCallback<T> {
    private final Map<class_2960, T> waitingFor;
    private final T registryDefault;
    private final Consumer<Function<class_2960, T>> onObjectsAvailable;
    private final BiConsumer<class_2960, T> onObjectReplaced;

    private RegistryWaiter(Map<class_2960, T> waitingFor, T registryDefault, Consumer<Function<class_2960, T>> onObjectsAvailable, BiConsumer<class_2960, T> onObjectReplaced) {
        this.waitingFor = waitingFor;
        this.registryDefault = registryDefault;
        this.onObjectsAvailable = onObjectsAvailable;
        this.onObjectReplaced = onObjectReplaced;
    }

    public static <T> void waitFor(Consumer<Function<class_2960, T>> onObjectsAvailable, BiConsumer<class_2960, T> onObjectReplaced, class_2378<T> registry, class_2960 ... waitFor) {
        Object registryDefault = registry instanceof class_2348 ? registry.method_10223(((class_2348)registry).method_10137()) : null;
        Map initialState = Arrays.stream(waitFor).collect(Collectors.toMap(id -> id, id -> registry.method_17966(id).orElse(registryDefault), (u, v) -> {
            throw new IllegalArgumentException("Duplicate value " + v);
        }, HashMap::new));
        RegistryWaiter<Object> waiter = new RegistryWaiter<Object>(initialState, registryDefault, onObjectsAvailable, onObjectReplaced);
        if (!super.tryExecuteAction()) {
            RegistryEntryAddedCallback.event(registry).register(waiter);
        }
    }

    public void onEntryAdded(int rawId, class_2960 id, T object) {
        if (this.waitingFor.containsKey(id)) {
            T oldValue = this.waitingFor.get(id);
            this.waitingFor.put(id, object);
            if (oldValue != this.registryDefault) {
                this.onObjectReplaced.accept(id, (class_2960)object);
            } else {
                this.tryExecuteAction();
            }
        }
    }

    private boolean tryExecuteAction() {
        if (!this.waitingFor.values().contains(this.registryDefault)) {
            this.onObjectsAvailable.accept(this.waitingFor::get);
            return true;
        }
        return false;
    }
}

