/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.harvest;

import com.google.common.base.Joiner;
import info.tehnut.harvest.Crop;
import info.tehnut.harvest.IReplantHandler;
import info.tehnut.harvest.config.HarvestConfig;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Harvest
implements ModInitializer {
    public static HarvestConfig CONFIG;
    public static final Logger LOGGER;
    public static final IReplantHandler DEFAULT_HANDLER;

    public void onInitialize() {
        System.out.println(class_2248.class.getCanonicalName());
        AutoConfig.register(HarvestConfig.class, GsonConfigSerializer::new);
        CONFIG = (HarvestConfig)AutoConfig.getConfigHolder(HarvestConfig.class).getConfig();
        if (CONFIG != null) {
            Harvest.debug("Successfully loaded config", new Object[0]);
            Harvest.debug("Currently enabled crops: {}", Joiner.on((String)" | ").join(CONFIG.getCrops()));
        }
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (!(world instanceof class_3218)) {
                return class_1269.field_5811;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            IReplantHandler handler = DEFAULT_HANDLER;
            class_2680 state = world.method_8320(hit.method_17777());
            class_1269 result = handler.handlePlant((class_3218)world, hit, state, player, world.method_8321(hit.method_17777()));
            if (result == class_1269.field_5812) {
                player.method_6104(hand);
                player.method_7322(Harvest.CONFIG.exhaustionPerHarvest);
            }
            Harvest.debug("Attempted crop harvest with result {} has completed", result);
            return result;
        });
    }

    public static void debug(String message, Object ... args) {
        if (CONFIG != null && Harvest.CONFIG.additionalLogging) {
            LOGGER.info("[DEBUG] " + message, args);
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"Harvest");
        DEFAULT_HANDLER = (world, hit, state, player, tileEntity) -> {
            Crop crop = CONFIG.getCrops().stream().filter(c -> c.test(state)).findFirst().orElse(null);
            if (crop == null) {
                Harvest.debug("No crop found for state {}", state);
                Harvest.debug("Valid crops {}", Joiner.on((String)" | ").join(CONFIG.getCrops()));
                return class_1269.field_5811;
            }
            class_2338 pos = hit.method_17777();
            List drops = class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)tileEntity, (class_1297)player, (class_1799)player.method_5998(class_1268.field_5808));
            boolean foundSeed = false;
            for (class_1799 drop : drops) {
                class_1792 dropItem = drop.method_7909();
                if (!(dropItem instanceof class_1747) || ((class_1747)dropItem).method_7711() != state.method_26204()) continue;
                foundSeed = true;
                drop.method_7934(1);
                break;
            }
            if (foundSeed) {
                drops.forEach(stack -> class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack));
                world.method_8501(pos, state.method_26204().method_9564());
                return class_1269.field_5812;
            }
            Harvest.debug("Failed to find a seed for {}", state);
            return class_1269.field_5814;
        };
    }
}

