/*
 * Decompiled with CFR 0.152.
 */
package makamys.satchels;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import makamys.satchels.SatchelsUtils;
import makamys.satchels.inventory.ContainerSatchels;
import makamys.satchels.inventory.InventoryAggregate;
import makamys.satchels.inventory.InventorySimpleNotifying;
import makamys.satchels.item.ItemPouch;
import makamys.satchels.lib.makamys.mclib.ccl.inventory.InventoryUtils2;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityPropertiesSatchels
implements IExtendedEntityProperties {
    public static final int SATCHEL_MAX_SLOTS = 9;
    public static final int POUCH_MAX_SLOTS = 8;
    public static final int POUCH_INITIAL_SLOTS = 3;
    private static final int SLOT_SATCHEL = 0;
    private static final int SLOT_LEFT_POUCH = 1;
    private static final int SLOT_RIGHT_POUCH = 2;
    public InventorySimpleNotifying equipment = new InventorySimpleNotifying(3, () -> this.updateInventories());
    public InventorySimple satchel = new InventorySimple(9);
    public InventorySimple leftPouch = new InventorySimple(8);
    public InventorySimple rightPouch = new InventorySimple(8);
    public InventoryAggregate aggregate = new InventoryAggregate(new IInventory[]{this.satchel, this.leftPouch, this.rightPouch});
    public EntityPlayer player;

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound satchelsTag = new NBTTagCompound();
        if (!SatchelsUtils.isInventoryEmpty((IInventory)this.equipment)) {
            satchelsTag.func_74782_a("Equipment", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.equipment.items));
        }
        if (!SatchelsUtils.isInventoryEmpty((IInventory)this.satchel)) {
            satchelsTag.func_74782_a("Satchel", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.satchel.items));
        }
        if (!SatchelsUtils.isInventoryEmpty((IInventory)this.leftPouch)) {
            satchelsTag.func_74782_a("LeftPouch", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.leftPouch.items));
        }
        if (!SatchelsUtils.isInventoryEmpty((IInventory)this.rightPouch)) {
            satchelsTag.func_74782_a("RightPouch", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.rightPouch.items));
        }
        if (!satchelsTag.func_150296_c().isEmpty()) {
            compound.func_74782_a("Satchels", (NBTBase)satchelsTag);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("Satchels")) {
            NBTTagCompound satchelsTag = compound.func_74775_l("Satchels");
            if (satchelsTag.func_74764_b("Equipment")) {
                SatchelsUtils.clearInventory((IInventory)this.equipment);
                InventoryUtils.readItemStacksFromTag((ItemStack[])this.equipment.items, (NBTTagList)satchelsTag.func_150295_c("Equipment", 10));
            }
            if (satchelsTag.func_74764_b("Satchel")) {
                SatchelsUtils.clearInventory((IInventory)this.satchel);
                InventoryUtils.readItemStacksFromTag((ItemStack[])this.satchel.items, (NBTTagList)satchelsTag.func_150295_c("Satchel", 10));
            }
            if (satchelsTag.func_74764_b("LeftPouch")) {
                SatchelsUtils.clearInventory((IInventory)this.leftPouch);
                InventoryUtils.readItemStacksFromTag((ItemStack[])this.leftPouch.items, (NBTTagList)satchelsTag.func_150295_c("LeftPouch", 10));
            }
            if (satchelsTag.func_74764_b("RightPouch")) {
                SatchelsUtils.clearInventory((IInventory)this.rightPouch);
                InventoryUtils.readItemStacksFromTag((ItemStack[])this.rightPouch.items, (NBTTagList)satchelsTag.func_150295_c("RightPouch", 10));
            }
            this.updateInventories();
        }
    }

    public void dropItems() {
        this.dropItems((IInventory)this.equipment);
    }

    public void dropItems(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            this.player.func_146097_a(stack, true, false);
            inv.func_70299_a(i, null);
        }
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
    }

    public void updateInventories() {
        ((ContainerSatchels)this.player.field_71069_bz).redoSlots();
    }

    public int getLeftPouchSlotCount() {
        return ItemPouch.getSlotCount(this.equipment.func_70301_a(1));
    }

    public int getRightPouchSlotCount() {
        return ItemPouch.getSlotCount(this.equipment.func_70301_a(2));
    }

    public boolean hasSatchel() {
        return this.getSatchelSlotCount() > 0;
    }

    public boolean hasLeftPouch() {
        return this.getLeftPouchSlotCount() > 0;
    }

    public boolean hasRightPouch() {
        return this.getRightPouchSlotCount() > 0;
    }

    public int getSatchelSlotCount() {
        return this.equipment.func_70301_a(0) != null ? 9 : 0;
    }

    public static EntityPropertiesSatchels fromPlayer(EntityPlayer player) {
        return (EntityPropertiesSatchels)player.getExtendedProperties("satchels");
    }

    public boolean preAddItemStackToInventory(ItemStack stack) {
        return this.addItemStackToInventory(stack, 0);
    }

    public boolean postAddItemStackToInventory(ItemStack stack) {
        return this.addItemStackToInventory(stack, 1);
    }

    private boolean addItemStackToInventory(ItemStack stack, int pass) {
        int left;
        if (stack == null || stack.field_77994_a == 0 || stack.func_77973_b() == null) {
            return false;
        }
        int originalSize = stack.field_77994_a;
        stack.field_77994_a = left = InventoryUtils2.insertItem(this.getEnabledInventoryRange(), stack, false, pass);
        return stack.field_77994_a != originalSize;
    }

    private InventoryRange getEnabledInventoryRange() {
        int i;
        InventoryRange range = new InventoryRange((IInventory)this.aggregate);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (this.hasSatchel()) {
            for (i = 0; i < this.satchel.func_70302_i_(); ++i) {
                slots.add(this.aggregate.toGlobalIdx((IInventory)this.satchel, i));
            }
        }
        if (this.hasLeftPouch()) {
            for (i = 0; i < this.getLeftPouchSlotCount(); ++i) {
                slots.add(this.aggregate.toGlobalIdx((IInventory)this.leftPouch, i));
            }
        }
        if (this.hasRightPouch()) {
            for (i = 0; i < this.getRightPouchSlotCount(); ++i) {
                slots.add(this.aggregate.toGlobalIdx((IInventory)this.rightPouch, i));
            }
        }
        range.slots = Ints.toArray(slots);
        return range;
    }
}

