/*
 * Decompiled with CFR 0.152.
 */
package makamys.satchels.inventory;

import codechicken.lib.inventory.InventorySimple;
import java.util.ArrayList;
import java.util.List;
import makamys.satchels.EntityPropertiesSatchels;
import makamys.satchels.SatchelsUtils;
import makamys.satchels.inventory.SlotDisabled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import org.apache.commons.lang3.tuple.Pair;

public class ContainerSatchels
extends ContainerPlayer {
    public List<Slot> leftPouchSlots = new ArrayList<Slot>();
    public List<Slot> rightPouchSlots = new ArrayList<Slot>();
    public List<Slot> satchelSlots = new ArrayList<Slot>();
    public boolean dirty;
    public EntityPropertiesSatchels satchelProps;
    List<Pair<Integer, Integer>> originalSlotPositions;
    private boolean shiftArmorSlots;

    public ContainerSatchels(EntityPlayer player) {
        super(player.field_71071_by, !player.field_70170_p.field_72995_K, player);
        Slot slot;
        int i;
        Slot slot2;
        int row;
        this.satchelProps = EntityPropertiesSatchels.fromPlayer(player);
        int bottomY = 120;
        for (row = 0; row < 8; ++row) {
            slot2 = new Slot((IInventory)this.satchelProps.leftPouch, row, -10, bottomY - row * 18);
            this.leftPouchSlots.add(slot2);
            this.func_75146_a(slot2);
        }
        for (row = 0; row < 8; ++row) {
            slot2 = new Slot((IInventory)this.satchelProps.rightPouch, row, 170, bottomY - row * 18);
            this.rightPouchSlots.add(slot2);
            this.func_75146_a(slot2);
        }
        InventorySimple satchelInv = this.satchelProps.satchel;
        for (i = 0; i < 9; ++i) {
            slot = new Slot((IInventory)satchelInv, i, 8 + i * 18, 66);
            this.satchelSlots.add(slot);
            this.func_75146_a(slot);
        }
        this.originalSlotPositions = new ArrayList<Pair<Integer, Integer>>();
        for (i = 0; i < this.field_75151_b.size(); ++i) {
            slot = (Slot)this.field_75151_b.get(i);
            this.originalSlotPositions.add((Pair<Integer, Integer>)Pair.of((Object)slot.field_75223_e, (Object)slot.field_75221_f));
        }
        this.redoSlots();
    }

    public void redoSlots() {
        int i;
        for (i = 0; i < this.satchelSlots.size(); ++i) {
            this.setEnabled(this.satchelSlots, i, this.satchelProps.hasSatchel());
        }
        for (i = 0; i < this.leftPouchSlots.size(); ++i) {
            this.setEnabled(this.leftPouchSlots, i, i < this.satchelProps.getLeftPouchSlotCount());
            this.setEnabled(this.rightPouchSlots, i, i < this.satchelProps.getRightPouchSlotCount());
        }
        this.shiftArmorSlots = this.leftPouchSlots.stream().anyMatch(s -> SatchelsUtils.isPointInRange(s.field_75221_f, 7, 79));
        for (i = 0; i < this.originalSlotPositions.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot instanceof SlotDisabled) continue;
            Pair<Integer, Integer> originalPosition = this.originalSlotPositions.get(i);
            slot.field_75223_e = (Integer)originalPosition.getLeft() + 16;
            slot.field_75221_f = (Integer)originalPosition.getRight() + (i >= 9 && this.satchelProps.hasSatchel() ? 18 : 0);
            if (slot.field_75222_d < 5 || slot.field_75222_d >= 9) continue;
            slot.field_75223_e += this.getArmorXOffset();
        }
    }

    public void setEnabled(List<Slot> list, int index, boolean enabled) {
        Slot slot = list.get(index);
        Slot newSlot = null;
        if (!(slot instanceof SlotDisabled) && !enabled) {
            if (slot.func_75216_d()) {
                if (!this.satchelProps.player.field_70170_p.field_72995_K) {
                    this.satchelProps.player.func_146097_a(slot.func_75211_c(), true, false);
                }
                slot.func_75215_d(null);
            }
            newSlot = new SlotDisabled(slot);
        } else if (slot instanceof SlotDisabled && enabled) {
            newSlot = ((SlotDisabled)slot).original;
        }
        if (newSlot != null) {
            list.set(index, newSlot);
            this.field_75151_b.set(slot.field_75222_d, newSlot);
        }
    }

    public List<Slot> getEnabledLeftPouchSlots() {
        return this.leftPouchSlots.subList(0, this.satchelProps.getLeftPouchSlotCount());
    }

    public List<Slot> getEnabledRightPouchSlots() {
        return this.rightPouchSlots.subList(0, this.satchelProps.getRightPouchSlotCount());
    }

    public int getArmorXOffset() {
        return this.shiftArmorSlots ? 2 : 0;
    }
}

