/*
 * Decompiled with CFR 0.152.
 */
package makamys.satchels.inventory;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryAggregate
implements IInventory {
    List<IInventory> inventories;

    public InventoryAggregate(IInventory ... inventories) {
        this.inventories = Arrays.stream(inventories).collect(Collectors.toList());
    }

    public int func_70302_i_() {
        return this.inventories.stream().mapToInt(i -> i.func_70302_i_()).sum();
    }

    public ItemStack func_70301_a(int globalIdx) {
        Pair<IInventory, Integer> localIdx = this.toLocalIdx(globalIdx);
        if (localIdx != null) {
            return ((IInventory)localIdx.getLeft()).func_70301_a(((Integer)localIdx.getRight()).intValue());
        }
        return null;
    }

    public Pair<IInventory, Integer> toLocalIdx(int globalIdx) {
        int invStartGlobal = 0;
        for (int i = 0; i < this.inventories.size(); ++i) {
            IInventory inv = this.inventories.get(i);
            if (globalIdx >= invStartGlobal && globalIdx < invStartGlobal + inv.func_70302_i_()) {
                return Pair.of((Object)inv, (Object)(globalIdx - invStartGlobal));
            }
            invStartGlobal += inv.func_70302_i_();
        }
        return Pair.of(null, (Object)-1);
    }

    public int toGlobalIdx(IInventory targetInv, int localIdx) {
        int invStartGlobal = 0;
        for (int i = 0; i < this.inventories.size(); ++i) {
            IInventory inv = this.inventories.get(i);
            if (targetInv == inv) {
                return invStartGlobal + localIdx;
            }
            invStartGlobal += inv.func_70302_i_();
        }
        return -1;
    }

    public ItemStack func_70298_a(int globalIdx, int arg) {
        Pair<IInventory, Integer> localIdx = this.toLocalIdx(globalIdx);
        if (localIdx != null) {
            return ((IInventory)localIdx.getLeft()).func_70298_a(((Integer)localIdx.getRight()).intValue(), arg);
        }
        return null;
    }

    public ItemStack func_70304_b(int globalIdx) {
        Pair<IInventory, Integer> localIdx = this.toLocalIdx(globalIdx);
        if (localIdx != null) {
            return ((IInventory)localIdx.getLeft()).func_70304_b(((Integer)localIdx.getRight()).intValue());
        }
        return null;
    }

    public void func_70299_a(int globalIdx, ItemStack arg) {
        Pair<IInventory, Integer> localIdx = this.toLocalIdx(globalIdx);
        if (localIdx != null) {
            ((IInventory)localIdx.getLeft()).func_70299_a(((Integer)localIdx.getRight()).intValue(), arg);
        }
    }

    public String func_145825_b() {
        return "aggregate{" + String.join((CharSequence)",", (CharSequence[])this.inventories.stream().map(i -> i.func_145825_b()).toArray(String[]::new)) + "}";
    }

    public boolean func_145818_k_() {
        return this.inventories.stream().anyMatch(i -> i.func_145818_k_());
    }

    public int func_70297_j_() {
        return this.inventories.stream().mapToInt(i -> i.func_70297_j_()).min().getAsInt();
    }

    public void func_70296_d() {
        this.inventories.stream().forEach(i -> i.func_70296_d());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventories.stream().allMatch(i -> i.func_70300_a(player));
    }

    public void func_70295_k_() {
        this.inventories.stream().forEach(i -> i.func_70295_k_());
    }

    public void func_70305_f() {
        this.inventories.stream().forEach(i -> i.func_70305_f());
    }

    public boolean func_94041_b(int globalIdx, ItemStack arg) {
        Pair<IInventory, Integer> localIdx = this.toLocalIdx(globalIdx);
        if (localIdx != null) {
            return ((IInventory)localIdx.getLeft()).func_94041_b(((Integer)localIdx.getRight()).intValue(), arg);
        }
        return false;
    }
}

