/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.ISeasonColorProvider;
import sereneseasons.api.season.Season;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.util.Color;

public class SeasonColorUtil {
    public static int multiplyColours(int colour1, int colour2) {
        return (int)((float)colour1 / 255.0f * ((float)colour2 / 255.0f) * 255.0f);
    }

    public static int overlayBlendChannel(int underColour, int overColour) {
        int retVal;
        if (underColour < 128) {
            retVal = SeasonColorUtil.multiplyColours(2 * underColour, overColour);
        } else {
            retVal = SeasonColorUtil.multiplyColours(2 * (255 - underColour), 255 - overColour);
            retVal = 255 - retVal;
        }
        return retVal;
    }

    public static int overlayBlend(int underColour, int overColour) {
        int r = SeasonColorUtil.overlayBlendChannel(underColour >> 16 & 0xFF, overColour >> 16 & 0xFF);
        int g = SeasonColorUtil.overlayBlendChannel(underColour >> 8 & 0xFF, overColour >> 8 & 0xFF);
        int b = SeasonColorUtil.overlayBlendChannel(underColour & 0xFF, overColour & 0xFF);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int mixColours(int a, int b, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int aA = a >> 24 & 0xFF;
        int aR = (a & 0xFF0000) >> 16;
        int aG = (a & 0xFF00) >> 8;
        int aB = a & 0xFF;
        int bA = b >> 24 & 0xFF;
        int bR = (b & 0xFF0000) >> 16;
        int bG = (b & 0xFF00) >> 8;
        int bB = b & 0xFF;
        int A = (int)((float)aA * iRatio + (float)bA * ratio);
        int R = (int)((float)aR * iRatio + (float)bR * ratio);
        int G = (int)((float)aG * iRatio + (float)bG * ratio);
        int B = (int)((float)aB * iRatio + (float)bB * ratio);
        return A << 24 | R << 16 | G << 8 | B;
    }

    public static int saturateColour(int colour, float saturationMultiplier) {
        Color newColor = new Color(colour);
        double[] hsv = newColor.toHSV();
        hsv[1] = hsv[1] * (double)saturationMultiplier;
        newColor = Color.convertHSVtoRGB(hsv[0], hsv[1], hsv[2]);
        return newColor.toInt();
    }

    public static int applySeasonalGrassColouring(ISeasonColorProvider colorProvider, Holder<Biome> biome, int originalColour) {
        int newColour;
        ResourceKey dimension = Minecraft.m_91087_().f_91073_.m_46472_();
        if (!BiomeConfig.enablesSeasonalEffects(biome) || !ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)dimension)) {
            return originalColour;
        }
        int overlay = colorProvider.getGrassOverlay();
        float saturationMultiplier = colorProvider.getGrassSaturationMultiplier();
        if (!((Boolean)ServerConfig.changeGrassColor.get()).booleanValue()) {
            overlay = Season.SubSeason.MID_SUMMER.getGrassOverlay();
            saturationMultiplier = Season.SubSeason.MID_SUMMER.getGrassSaturationMultiplier();
        }
        int fixedColour = newColour = overlay == 0xFFFFFF ? originalColour : SeasonColorUtil.overlayBlend(originalColour, overlay);
        if (BiomeConfig.lessColorChange(biome)) {
            fixedColour = SeasonColorUtil.mixColours(newColour, originalColour, 0.75f);
        }
        return saturationMultiplier != -1.0f ? SeasonColorUtil.saturateColour(fixedColour, saturationMultiplier) : fixedColour;
    }

    public static int applySeasonalFoliageColouring(ISeasonColorProvider colorProvider, Holder<Biome> biome, int originalColour) {
        int newColour;
        ResourceKey dimension = Minecraft.m_91087_().f_91073_.m_46472_();
        if (!BiomeConfig.enablesSeasonalEffects(biome) || !ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)dimension)) {
            return originalColour;
        }
        int overlay = colorProvider.getFoliageOverlay();
        float saturationMultiplier = colorProvider.getFoliageSaturationMultiplier();
        if (!((Boolean)ServerConfig.changeFoliageColor.get()).booleanValue()) {
            overlay = Season.SubSeason.MID_SUMMER.getFoliageOverlay();
            saturationMultiplier = Season.SubSeason.MID_SUMMER.getFoliageSaturationMultiplier();
        }
        int fixedColour = newColour = overlay == 0xFFFFFF ? originalColour : SeasonColorUtil.overlayBlend(originalColour, overlay);
        if (BiomeConfig.lessColorChange(biome)) {
            fixedColour = SeasonColorUtil.mixColours(newColour, originalColour, 0.75f);
        }
        return saturationMultiplier != -1.0f ? SeasonColorUtil.saturateColour(fixedColour, saturationMultiplier) : fixedColour;
    }
}

