/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.HashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;

@Mod.EventBusSubscriber
public class TimeSkipHandler {
    public static final HashMap<ResourceKey<Level>, Long> lastDayTimes = new HashMap();

    @SubscribeEvent
    public static void onWorldLoaded(LevelEvent.Load event) {
        lastDayTimes.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            long lastDayTime;
            long difference;
            ServerLevel world = (ServerLevel)event.level;
            long dayTime = world.m_6106_().m_6792_();
            if (!lastDayTimes.containsKey(world.m_46472_())) {
                lastDayTimes.put((ResourceKey<Level>)world.m_46472_(), dayTime);
            }
            if ((difference = dayTime - (lastDayTime = lastDayTimes.get(world.m_46472_()).longValue())) < 0L) {
                difference += 24000L;
            }
            if (difference > 1L) {
                SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)world);
                seasonData.seasonCycleTicks = (int)((long)seasonData.seasonCycleTicks + difference);
                seasonData.m_77762_();
                SeasonHandler.sendSeasonUpdate((Level)world);
            }
            lastDayTimes.put((ResourceKey<Level>)world.m_46472_(), dayTime);
        }
    }
}

