/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;

@Mod.EventBusSubscriber
public class SeasonalCropGrowthHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemTooltipAdded(ItemTooltipEvent event) {
        ModFertility.setupTooltips(event);
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ModFertility.populate();
    }

    @SubscribeEvent
    public static void onCropGrowth(BlockEvent.CropGrowEvent event) {
        BlockState plant = event.getState();
        Block plantBlock = plant.m_60734_();
        Level level = (Level)event.getLevel();
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        boolean isFertile = ModFertility.isCropFertile(blockRegistry.m_7981_((Object)plantBlock).toString(), level, event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !SeasonalCropGrowthHandler.isGlassAboveBlock(level, event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && level.m_213780_().m_188503_(6) != 0) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    event.setResult(Event.Result.DENY);
                    event.getLevel().m_46961_(event.getPos(), false);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onApplyBonemeal(BonemealEvent event) {
        BlockState plant = event.getBlock();
        Block plantBlock = plant.m_60734_();
        Level level = event.getLevel();
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        boolean isFertile = ModFertility.isCropFertile(blockRegistry.m_7981_((Object)plantBlock).toString(), level, event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !SeasonalCropGrowthHandler.isGlassAboveBlock(level, event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && level.m_213780_().m_188503_(6) != 0) {
                event.setResult(Event.Result.DEFAULT);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setCanceled(true);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    event.setCanceled(true);
                    level.m_46961_(event.getPos(), false);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isGlassAboveBlock(Level world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.m_8055_(cropPos.m_7918_(0, i + 1, 0)).m_204336_(ModTags.Blocks.GREENHOUSE_GLASS)) continue;
            return true;
        }
        return false;
    }
}

