/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sereneseasons.config.ServerConfig;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;

@OnlyIn(value=Dist.CLIENT)
public class SeasonColorHandlers {
    private static ColorResolver originalGrassColorResolver;
    private static ColorResolver originalFoliageColorResolver;

    public static void setup() {
        SeasonColorHandlers.registerGrassAndFoliageColorHandlers();
        SeasonColorHandlers.registerBirchColorHandler();
    }

    private static void registerGrassAndFoliageColorHandlers() {
        originalGrassColorResolver = BiomeColors.f_108789_;
        originalFoliageColorResolver = BiomeColors.f_108790_;
        BiomeColors.f_108789_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> biomeRegistry.m_203636_(key)).orElse(null);
            int originalColor = originalGrassColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                SeasonTime calendar = SeasonHandler.getClientSeasonTime();
                Enum colorProvider = biomeHolder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalGrassColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
        BiomeColors.f_108790_ = (biome, x, z) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(key -> biomeRegistry.m_203636_(key)).orElse(null);
            int originalColor = originalFoliageColorResolver.m_130045_(biome, x, z);
            if (biomeHolder != null) {
                SeasonTime calendar = SeasonHandler.getClientSeasonTime();
                Enum colorProvider = biomeHolder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                return SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            }
            return originalColor;
        };
    }

    private static void registerBirchColorHandler() {
        Minecraft.m_91087_().m_91298_().m_92589_((state, dimensionReader, pos, tintIndex) -> {
            Holder biome;
            int birchColor = FoliageColor.m_46112_();
            Level level = Minecraft.m_91087_().f_91074_.m_9236_();
            ResourceKey dimension = Minecraft.m_91087_().f_91074_.m_9236_().m_46472_();
            if (level != null && pos != null && ((Boolean)ServerConfig.changeBirchColor.get()).booleanValue() && ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)dimension) && !(biome = level.m_204166_(pos)).m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
                SeasonTime calendar = SeasonHandler.getClientSeasonTime();
                Enum colorProvider = biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                birchColor = colorProvider.getBirchColor();
                if (biome.m_203656_(ModTags.Biomes.LESSER_COLOR_CHANGE_BIOMES)) {
                    birchColor = SeasonColorUtil.mixColours(colorProvider.getBirchColor(), FoliageColor.m_46112_(), 0.75f);
                }
            }
            return birchColor;
        }, new Block[]{Blocks.f_50052_});
    }
}

