/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;

public class SeasonHooks {
    public static boolean shouldSnowHook(Biome biome, LevelReader levelReader, BlockPos pos) {
        BlockState blockstate;
        if (((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos) || !((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && biome.m_198906_(pos)) {
            return false;
        }
        return pos.m_123342_() >= levelReader.m_141937_() && pos.m_123342_() < levelReader.m_151558_() && levelReader.m_45517_(LightLayer.BLOCK, pos) < 10 && (blockstate = levelReader.m_8055_(pos)).m_60795_() && Blocks.f_50125_.m_49966_().m_60710_(levelReader, pos);
    }

    public static boolean shouldFreezeWarmEnoughToRainHook(Biome biome, BlockPos pos, LevelReader levelReader) {
        return (Boolean)SeasonsConfig.generateSnowAndIce.get() != false && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos) || (Boolean)SeasonsConfig.generateSnowAndIce.get() == false && biome.m_198906_(pos);
    }

    public static boolean isRainingAtHook(Level level, BlockPos position) {
        if (!level.m_46471_()) {
            return false;
        }
        if (!level.m_45527_(position)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, position).m_123342_() > position.m_123342_()) {
            return false;
        }
        Holder biome = level.m_204166_(position);
        if (ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()) && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return SeasonHooks.getPrecipitationAtSeasonal(level, (Holder<Biome>)biome, position) == Biome.Precipitation.RAIN && SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder<Biome>)biome, position);
        }
        return ((Biome)biome.m_203334_()).m_264600_(position) == Biome.Precipitation.RAIN && ((Biome)biome.m_203334_()).m_47505_(position) >= 0.15f;
    }

    public static Biome.Precipitation getPrecipitationAtTickIceAndSnowHook(LevelReader level, Biome biome, BlockPos pos) {
        if (!biome.m_264473_()) {
            return Biome.Precipitation.NONE;
        }
        boolean shouldSnow = (Boolean)SeasonsConfig.generateSnowAndIce.get() != false && SeasonHooks.coldEnoughToSnowSeasonal(level, pos) || (Boolean)SeasonsConfig.generateSnowAndIce.get() == false && biome.m_198904_(pos);
        return shouldSnow ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Biome.Precipitation getPrecipitationAtLevelRendererHook(Holder<Biome> biome, BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (!SeasonHooks.hasPrecipitationSeasonal((Level)level, biome)) {
            return Biome.Precipitation.NONE;
        }
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static boolean coldEnoughToSnowSeasonal(LevelReader level, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal(level, (Holder<Biome>)level.m_204166_(pos), pos);
    }

    public static boolean coldEnoughToSnowSeasonal(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        return !SeasonHooks.warmEnoughToRainSeasonal(level, biome, pos);
    }

    public static boolean warmEnoughToRainSeasonal(LevelReader level, BlockPos pos) {
        return SeasonHooks.warmEnoughToRainSeasonal(level, (Holder<Biome>)level.m_204166_(pos), pos);
    }

    public static boolean warmEnoughToRainSeasonal(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.getBiomeTemperature(level, biome, pos) >= 0.15f;
    }

    public static float getBiomeTemperature(LevelReader level, Holder<Biome> biome, BlockPos pos) {
        if (!(level instanceof Level)) {
            return ((Biome)biome.m_203334_()).m_47505_(pos);
        }
        return SeasonHooks.getBiomeTemperature((Level)level, biome, pos);
    }

    public static float getBiomeTemperature(Level level, Holder<Biome> biome, BlockPos pos) {
        if (!ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()) || biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return ((Biome)biome.m_203334_()).m_47505_(pos);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(level).getSeasonCycleTicks()).getSubSeason(), biome, pos);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, Holder<Biome> biome, BlockPos pos) {
        boolean tropicalBiome = biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES);
        float biomeTemp = ((Biome)biome.m_203334_()).m_47505_(pos);
        if (!tropicalBiome && ((Biome)biome.m_203334_()).m_47554_() <= 0.8f && !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = Mth.m_14036_((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }

    public static boolean hasPrecipitationSeasonal(Level level, Holder<Biome> biome) {
        if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(level).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
        }
        return ((Biome)biome.m_203334_()).m_264473_();
    }

    public static Biome.Precipitation getPrecipitationAtSeasonal(Level level, Holder<Biome> biome, BlockPos pos) {
        if (!SeasonHooks.hasPrecipitationSeasonal(level, biome)) {
            return Biome.Precipitation.NONE;
        }
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, pos) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }
}

