/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.mixins.CameraAccessor;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_636;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ShoulderRenderer {
    private static final ShoulderRenderer INSTANCE = new ShoulderRenderer();
    private double cameraDistance;
    private Vec2f lastTranslation = Vec2f.ZERO;
    private Vec2f translation = Vec2f.ZERO;
    private Vec2f projected;

    public void offsetCrosshair(class_4587 poseStack, class_1041 window, float partialTicks) {
        if (this.projected != null) {
            Vec2f scaledDimensions = new Vec2f(window.method_4486(), window.method_4502());
            Vec2f dimensions = new Vec2f(window.method_4480(), window.method_4507());
            Vec2f scale = scaledDimensions.divide(dimensions);
            Vec2f center = dimensions.divide(2.0f);
            Vec2f projectedOffset = this.projected.subtract(center).scale(scale);
            Vec2f interpolated = projectedOffset.subtract(this.lastTranslation).scale(partialTicks);
            this.translation = this.lastTranslation.add(interpolated);
        }
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing()) {
            poseStack.method_22903();
            poseStack.method_23760().method_23761().translate(this.translation.getX(), -this.translation.getY(), 0.0f);
            this.lastTranslation = this.translation;
        } else {
            this.lastTranslation = Vec2f.ZERO;
        }
    }

    public void clearCrosshairOffset(class_4587 poseStack) {
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing() && !Vec2f.ZERO.equals(this.lastTranslation)) {
            poseStack.method_22909();
        }
    }

    public void offsetCamera(class_4184 camera, class_1937 level, double partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing() && level != null) {
            CameraAccessor accessor = (CameraAccessor)camera;
            double x = class_3532.method_16436((double)partialTick, (double)camera.method_19331().field_6014, (double)camera.method_19331().method_23317());
            double y = class_3532.method_16436((double)partialTick, (double)camera.method_19331().field_6036, (double)camera.method_19331().method_23318()) + class_3532.method_16436((double)partialTick, (double)accessor.getEyeHeightOld(), (double)accessor.getEyeHeight());
            double z = class_3532.method_16436((double)partialTick, (double)camera.method_19331().field_5969, (double)camera.method_19331().method_23321());
            accessor.invokeSetPosition(x, y, z);
            class_243 offset = new class_243(-Config.CLIENT.getOffsetZ(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetX());
            this.cameraDistance = this.calcCameraDistance(camera, level, accessor.invokeGetMaxZoom(offset.method_1033()));
            class_243 scaled = offset.method_1029().method_1021(this.cameraDistance);
            accessor.invokeMove(scaled.field_1352, scaled.field_1351, scaled.field_1350);
        }
    }

    private double calcCameraDistance(class_4184 camera, class_1937 level, double distance) {
        class_243 cameraPos = camera.method_19326();
        class_243 cameraOffset = ShoulderHelper.calcCameraOffset(camera, distance);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            class_243 to;
            class_243 offset = new class_243((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).method_1021(2.0).method_1023(1.0, 1.0, 1.0).method_1021(0.075);
            class_243 from = cameraPos.method_1019(offset);
            class_3959 context = new class_3959(from, to = from.method_1019(cameraOffset), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, camera.method_19331());
            class_3965 hitResult = level.method_17742(context);
            if (hitResult == null || !((newDistance = hitResult.method_17784().method_1022(cameraPos)) < distance)) continue;
            distance = newDistance - 0.2;
        }
        return distance;
    }

    public void updateDynamicRaytrace(class_4184 camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing()) {
            class_310 minecraft = class_310.method_1551();
            class_636 gameMode = minecraft.field_1761;
            class_239 hitResult = ShoulderHelper.traceBlocksAndEntities(camera, gameMode, this.getPlayerReach(), class_3959.class_242.field_1348, partialTick, true, false);
            class_243 position = hitResult.method_17784().method_1020(camera.method_19326());
            this.projected = this.project2D(position, modelViewMatrix, projectionMatrix);
        }
    }

    @Nullable
    private Vec2f project2D(class_243 position, Matrix4f modelView, Matrix4f projection) {
        class_1041 window = class_310.method_1551().method_22683();
        int screenWidth = window.method_4480();
        int screenHeight = window.method_4507();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.method_10216(), (float)position.method_10214(), (float)position.method_10215(), 1.0f);
        vec.mul((Matrix4fc)modelView);
        vec.mul((Matrix4fc)projection);
        if (vec.w() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.w() * 0.5f;
        float x = (vec.x() * w + 0.5f) * (float)screenWidth;
        float y = (vec.y() * w + 0.5f) * (float)screenHeight;
        float z = vec.z() * w + 0.5f;
        vec.set(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }

    public boolean skipEntityRendering() {
        return Config.CLIENT.keepCameraOutOfHead() && this.cameraDistance < (double)(class_310.method_1551().method_1560().method_17681() * 0.75f) && ShoulderInstance.getInstance().doShoulderSurfing();
    }

    public double getPlayerReach() {
        return Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
    }

    public double getCameraDistance() {
        return this.cameraDistance;
    }

    public static ShoulderRenderer getInstance() {
        return INSTANCE;
    }
}

