/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.teamderpy.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.teamderpy.shouldersurfing.client.ShoulderRenderer;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_5272;
import net.minecraft.class_636;
import net.minecraft.class_7923;

public class ShoulderHelper {
    private static final Predicate<class_1297> ENTITY_IS_PICKABLE = entity -> !entity.method_7325() && entity.method_5863();
    private static final class_2960 PULL_PROPERTY = new class_2960("pull");
    private static final class_2960 THROWING_PROPERTY = new class_2960("throwing");
    private static final class_2960 CHARGED_PROPERTY = new class_2960("charged");

    public static ShoulderLook shoulderSurfingLook(class_4184 camera, class_1297 entity, float partialTicks, double distanceSq) {
        class_243 cameraOffset = ShoulderHelper.calcCameraOffset(camera, ShoulderRenderer.getInstance().getCameraDistance());
        class_243 headOffset = ShoulderHelper.calcRayTraceHeadOffset(camera, cameraOffset);
        class_243 cameraPos = entity.method_5836(partialTicks).method_1019(cameraOffset);
        class_243 viewVector = entity.method_5828(partialTicks);
        if (Config.CLIENT.limitPlayerReach() && headOffset.method_1027() < distanceSq) {
            distanceSq -= headOffset.method_1027();
        }
        double distance = Math.sqrt(distanceSq) + cameraOffset.method_1022(headOffset);
        class_243 traceEnd = cameraPos.method_1019(viewVector.method_1021(distance));
        return new ShoulderLook(cameraPos, traceEnd, headOffset);
    }

    public static class_243 calcCameraOffset(@Nonnull class_4184 camera, double distance) {
        double dX = (double)camera.method_19336().x() * Config.CLIENT.getOffsetY() + (double)camera.method_35689().x() * Config.CLIENT.getOffsetX() + (double)camera.method_19335().x() * -Config.CLIENT.getOffsetZ();
        double dY = (double)camera.method_19336().y() * Config.CLIENT.getOffsetY() + (double)camera.method_35689().y() * Config.CLIENT.getOffsetX() + (double)camera.method_19335().y() * -Config.CLIENT.getOffsetZ();
        double dZ = (double)camera.method_19336().z() * Config.CLIENT.getOffsetY() + (double)camera.method_35689().z() * Config.CLIENT.getOffsetX() + (double)camera.method_19335().z() * -Config.CLIENT.getOffsetZ();
        return new class_243(dX, dY, dZ).method_1029().method_1021(distance);
    }

    public static class_243 calcRayTraceHeadOffset(@Nonnull class_4184 camera, class_243 cameraOffset) {
        class_243 lookVector = new class_243(camera.method_19335());
        return ShoulderHelper.calcPlaneWithLineIntersection(class_243.field_1353, lookVector, cameraOffset, lookVector);
    }

    public static class_243 calcPlaneWithLineIntersection(class_243 planePoint, class_243 planeNormal, class_243 linePoint, class_243 lineNormal) {
        double distance = (planeNormal.method_1026(planePoint) - planeNormal.method_1026(linePoint)) / planeNormal.method_1026(lineNormal);
        return linePoint.method_1019(lineNormal.method_1021(distance));
    }

    public static class_239 traceBlocksAndEntities(class_4184 camera, class_636 gameMode, double playerReachOverride, class_3959.class_242 fluidContext, float partialTick, boolean traceEntities, boolean shoulderSurfing) {
        double distance;
        class_3966 entityHit;
        class_1297 entity = camera.method_19331();
        double playerReach = Math.max((double)gameMode.method_2904(), playerReachOverride);
        class_3965 blockHit = ShoulderHelper.traceBlocks(camera, entity, fluidContext, playerReach, partialTick, shoulderSurfing);
        if (!traceEntities) {
            return blockHit;
        }
        class_243 eyePosition = entity.method_5836(partialTick);
        if (gameMode.method_2926()) {
            playerReach = Math.max(playerReach, gameMode.method_2920().method_8386() ? 6.0 : 3.0);
        }
        if (blockHit != null) {
            playerReach = blockHit.method_17784().method_1022(eyePosition);
        }
        if ((entityHit = ShoulderHelper.traceEntities(camera, entity, playerReach, partialTick, shoulderSurfing)) != null && ((distance = eyePosition.method_1022(entityHit.method_17784())) < playerReach || blockHit == null)) {
            return entityHit;
        }
        return blockHit;
    }

    public static class_3966 traceEntities(class_4184 camera, class_1297 entity, double playerReach, float partialTick, boolean shoulderSurfing) {
        double playerReachSq = playerReach * playerReach;
        class_243 viewVector = entity.method_5828(1.0f).method_1021(playerReach);
        class_243 eyePosition = entity.method_5836(partialTick);
        class_238 aabb = entity.method_5829().method_18804(viewVector).method_1009(1.0, 1.0, 1.0);
        if (shoulderSurfing) {
            ShoulderLook look = ShoulderHelper.shoulderSurfingLook(camera, entity, partialTick, playerReachSq);
            class_243 from = eyePosition.method_1019(look.headOffset());
            class_243 to = look.traceEndPos();
            aabb = aabb.method_997(look.headOffset());
            return class_1675.method_18075((class_1297)entity, (class_243)from, (class_243)to, (class_238)aabb, ENTITY_IS_PICKABLE, (double)from.method_1025(to));
        }
        class_243 from = eyePosition;
        class_243 to = from.method_1019(viewVector);
        return class_1675.method_18075((class_1297)entity, (class_243)from, (class_243)to, (class_238)aabb, ENTITY_IS_PICKABLE, (double)playerReachSq);
    }

    public static class_3965 traceBlocks(class_4184 camera, class_1297 entity, class_3959.class_242 fluidContext, double distance, float partialTick, boolean shoulderSurfing) {
        class_243 eyePosition = entity.method_5836(partialTick);
        if (shoulderSurfing) {
            ShoulderLook look = ShoulderHelper.shoulderSurfingLook(camera, entity, partialTick, distance * distance);
            class_243 from = eyePosition.method_1019(look.headOffset());
            class_243 to = look.traceEndPos();
            return entity.field_6002.method_17742(new class_3959(from, to, class_3959.class_3960.field_17559, fluidContext, entity));
        }
        class_243 from = eyePosition;
        class_243 view = entity.method_5828(partialTick);
        class_243 to = from.method_1019(view.method_1021(distance));
        return entity.field_6002.method_17742(new class_3959(from, to, class_3959.class_3960.field_17559, fluidContext, entity));
    }

    public static boolean isHoldingAdaptiveItem() {
        class_310 minecraft = class_310.method_1551();
        class_1297 class_12972 = minecraft.field_1719;
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            boolean result = ShoulderHelper.isHoldingAdaptiveItemInternal(minecraft, entity);
            for (IAdaptiveItemCallback adaptiveItemCallback : ShoulderSurfingRegistrar.getInstance().getAdaptiveItemCallbacks()) {
                result |= adaptiveItemCallback.isHoldingAdaptiveItem(minecraft, entity);
            }
            return result;
        }
        return false;
    }

    private static boolean isHoldingAdaptiveItemInternal(class_310 minecraft, class_1309 entity) {
        class_1792 useItem = entity.method_6030().method_7909();
        List<? extends String> overrides = Config.CLIENT.getAdaptiveCrosshairItems();
        if (class_5272.method_27878((class_1792)useItem, (class_2960)PULL_PROPERTY) != null || class_5272.method_27878((class_1792)useItem, (class_2960)THROWING_PROPERTY) != null) {
            return true;
        }
        if (overrides.contains(class_7923.field_41178.method_10221((Object)useItem).toString())) {
            return true;
        }
        for (class_1799 handStack : entity.method_5877()) {
            class_1792 handItem = handStack.method_7909();
            if (class_5272.method_27878((class_1792)handItem, (class_2960)CHARGED_PROPERTY) != null) {
                return true;
            }
            if (!overrides.contains(class_7923.field_41178.method_10221((Object)handItem).toString())) continue;
            return true;
        }
        return false;
    }

    public record ShoulderLook(class_243 cameraPos, class_243 traceEndPos, class_243 headOffset) {
    }
}

