/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.mojang.math.Vector3f;
import com.teamderpy.shouldersurfing.api.callback.IAdaptiveItemCallback;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.client.ShoulderRenderer;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ShoulderHelper {
    private static final Predicate<Entity> ENTITY_IS_PICKABLE = entity -> !entity.m_5833_() && entity.m_6087_();
    private static final ResourceLocation PULL_PROPERTY = new ResourceLocation("pull");
    private static final ResourceLocation THROWING_PROPERTY = new ResourceLocation("throwing");
    private static final ResourceLocation CHARGED_PROPERTY = new ResourceLocation("charged");

    public static ShoulderLook shoulderSurfingLook(Camera camera, Entity entity, float partialTick, double distanceSq) {
        Vec3 cameraOffset = ShoulderHelper.calcCameraOffset(camera, ShoulderRenderer.getInstance().getCameraDistance(), partialTick);
        Vec3 headOffset = ShoulderHelper.calcRayTraceHeadOffset(camera, cameraOffset);
        Vec3 cameraPos = entity.m_20299_(partialTick).m_82549_(cameraOffset);
        Vec3 viewVector = entity.m_20252_(partialTick);
        if (Config.CLIENT.limitPlayerReach() && headOffset.m_82556_() < distanceSq) {
            distanceSq -= headOffset.m_82556_();
        }
        double distance = Math.sqrt(distanceSq) + cameraOffset.m_82554_(headOffset);
        Vec3 traceEnd = cameraPos.m_82549_(viewVector.m_82490_(distance));
        return new ShoulderLook(cameraPos, traceEnd, headOffset);
    }

    public static Vec3 calcCameraOffset(@NotNull Camera camera, double distance, float partialTick) {
        ShoulderInstance instance = ShoulderInstance.getInstance();
        double offsetX = Mth.m_14139_((double)partialTick, (double)instance.getOffsetXOld(), (double)instance.getOffsetX());
        double offsetY = Mth.m_14139_((double)partialTick, (double)instance.getOffsetYOld(), (double)instance.getOffsetY());
        double offsetZ = Mth.m_14139_((double)partialTick, (double)instance.getOffsetZOld(), (double)instance.getOffsetZ());
        return new Vec3(camera.m_90597_()).m_82490_(offsetY).m_82549_(new Vec3(camera.m_167686_()).m_82490_(offsetX)).m_82549_(new Vec3(camera.m_90596_()).m_82490_(-offsetZ)).m_82541_().m_82490_(distance);
    }

    public static Vec3 calcRayTraceHeadOffset(@NotNull Camera camera, Vec3 cameraOffset) {
        Vec3 lookVector = new Vec3(camera.m_90596_());
        return ShoulderHelper.calcPlaneWithLineIntersection(Vec3.f_82478_, lookVector, cameraOffset, lookVector);
    }

    public static Vec3 calcPlaneWithLineIntersection(Vec3 planePoint, Vec3 planeNormal, Vec3 linePoint, Vec3 lineNormal) {
        double distance = (planeNormal.m_82526_(planePoint) - planeNormal.m_82526_(linePoint)) / planeNormal.m_82526_(lineNormal);
        return linePoint.m_82549_(lineNormal.m_82490_(distance));
    }

    public static HitResult traceBlocksAndEntities(Camera camera, MultiPlayerGameMode gameMode, double playerReachOverride, ClipContext.Fluid fluidContext, float partialTick, boolean traceEntities, boolean shoulderSurfing) {
        double distance;
        EntityHitResult entityHit;
        Entity entity = camera.m_90592_();
        double playerReach = Math.max((double)gameMode.m_105286_(), playerReachOverride);
        BlockHitResult blockHit = ShoulderHelper.traceBlocks(camera, entity, fluidContext, playerReach, partialTick, shoulderSurfing);
        if (!traceEntities) {
            return blockHit;
        }
        Vec3 eyePosition = entity.m_20299_(partialTick);
        if (gameMode.m_105291_()) {
            playerReach = Math.max(playerReach, gameMode.m_105295_().m_46408_() ? 6.0 : 3.0);
        }
        if (blockHit != null) {
            playerReach = blockHit.m_82450_().m_82554_(eyePosition);
        }
        if ((entityHit = ShoulderHelper.traceEntities(camera, entity, playerReach, partialTick, shoulderSurfing)) != null && ((distance = eyePosition.m_82554_(entityHit.m_82450_())) < playerReach || blockHit == null)) {
            return entityHit;
        }
        return blockHit;
    }

    public static EntityHitResult traceEntities(Camera camera, Entity entity, double playerReach, float partialTick, boolean shoulderSurfing) {
        double playerReachSq = playerReach * playerReach;
        Vec3 viewVector = entity.m_20252_(1.0f).m_82490_(playerReach);
        Vec3 eyePosition = entity.m_20299_(partialTick);
        AABB aabb = entity.m_142469_().m_82369_(viewVector).m_82377_(1.0, 1.0, 1.0);
        if (shoulderSurfing) {
            ShoulderLook look = ShoulderHelper.shoulderSurfingLook(camera, entity, partialTick, playerReachSq);
            Vec3 from = eyePosition.m_82549_(look.headOffset());
            Vec3 to = look.traceEndPos();
            aabb = aabb.m_82383_(look.headOffset());
            return ProjectileUtil.m_37287_((Entity)entity, (Vec3)from, (Vec3)to, (AABB)aabb, ENTITY_IS_PICKABLE, (double)from.m_82557_(to));
        }
        Vec3 from = eyePosition;
        Vec3 to = from.m_82549_(viewVector);
        return ProjectileUtil.m_37287_((Entity)entity, (Vec3)from, (Vec3)to, (AABB)aabb, ENTITY_IS_PICKABLE, (double)playerReachSq);
    }

    public static BlockHitResult traceBlocks(Camera camera, Entity entity, ClipContext.Fluid fluidContext, double distance, float partialTick, boolean shoulderSurfing) {
        Vec3 eyePosition = entity.m_20299_(partialTick);
        if (shoulderSurfing) {
            ShoulderLook look = ShoulderHelper.shoulderSurfingLook(camera, entity, partialTick, distance * distance);
            Vec3 from = eyePosition.m_82549_(look.headOffset());
            Vec3 to = look.traceEndPos();
            return entity.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.OUTLINE, fluidContext, entity));
        }
        Vec3 from = eyePosition;
        Vec3 view = entity.m_20252_(partialTick);
        Vec3 to = from.m_82549_(view.m_82490_(distance));
        return entity.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.OUTLINE, fluidContext, entity));
    }

    public static boolean isHoldingAdaptiveItem() {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91075_;
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            boolean result = ShoulderHelper.isHoldingAdaptiveItemInternal(minecraft, entity2);
            for (IAdaptiveItemCallback adaptiveItemCallback : ShoulderSurfingRegistrar.getInstance().getAdaptiveItemCallbacks()) {
                result |= adaptiveItemCallback.isHoldingAdaptiveItem(minecraft, entity2);
            }
            return result;
        }
        return false;
    }

    private static boolean isHoldingAdaptiveItemInternal(Minecraft minecraft, LivingEntity entity) {
        Item useItem = entity.m_21211_().m_41720_();
        List<? extends String> overrides = Config.CLIENT.getAdaptiveCrosshairItems();
        if (ItemProperties.m_117829_((Item)useItem, (ResourceLocation)PULL_PROPERTY) != null || ItemProperties.m_117829_((Item)useItem, (ResourceLocation)THROWING_PROPERTY) != null) {
            return true;
        }
        if (overrides.contains(Registry.f_122827_.m_7981_((Object)useItem).toString())) {
            return true;
        }
        for (ItemStack handStack : entity.m_6167_()) {
            Item handItem = handStack.m_41720_();
            if (ItemProperties.m_117829_((Item)handItem, (ResourceLocation)CHARGED_PROPERTY) != null) {
                return true;
            }
            if (!overrides.contains(Registry.f_122827_.m_7981_((Object)handItem).toString())) continue;
            return true;
        }
        return false;
    }

    public static double angle(Vector3f a, Vector3f b) {
        return Math.acos((double)a.m_122276_(b) / (ShoulderHelper.length(a) * ShoulderHelper.length(b)));
    }

    public static double length(Vector3f vec) {
        return Mth.m_14116_((float)(vec.m_122239_() * vec.m_122239_() + vec.m_122260_() * vec.m_122260_() + vec.m_122269_() * vec.m_122269_()));
    }

    public record ShoulderLook(Vec3 cameraPos, Vec3 traceEndPos, Vec3 headOffset) {
    }
}

