/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.forge;

import com.teamderpy.shouldersurfing.client.KeyHandler;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.client.ShoulderRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            ShoulderInstance.getInstance().tick();
        }
    }

    @SubscribeEvent
    public static void preRenderLivingEntityEvent(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        if (event.isCancelable() && event.getEntity().equals((Object)Minecraft.m_91087_().m_91288_()) && Minecraft.m_91087_().f_91080_ == null && ShoulderRenderer.getInstance().skipEntityRendering()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preRenderGuiOverlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (VanillaGuiOverlay.CROSSHAIR.id().equals((Object)event.getOverlay().id())) {
            ShoulderRenderer.getInstance().offsetCrosshair(event.getPoseStack(), event.getWindow(), event.getPartialTick());
        } else if (VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id().equals((Object)event.getOverlay().id())) {
            ShoulderRenderer.getInstance().clearCrosshairOffset(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void computeCameraAnglesEvent(ViewportEvent.ComputeCameraAngles event) {
        ShoulderRenderer.getInstance().offsetCamera(event.getCamera(), (Level)Minecraft.m_91087_().f_91073_, (float)event.getPartialTick());
    }

    @SubscribeEvent
    public static void renderLevelStageEvent(RenderLevelStageEvent event) {
        if (RenderLevelStageEvent.Stage.AFTER_SKY.equals(event.getStage())) {
            ShoulderRenderer.getInstance().updateDynamicRaytrace(event.getCamera(), event.getPoseStack().m_85850_().m_85861_(), event.getProjectionMatrix(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void keyInputEvent(InputEvent event) {
        KeyHandler.onInput();
    }
}

