/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.compatibility;

import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPickerAccessor;
import mcp.mobius.waila.api.IPickerResults;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.plugin.core.pick.ObjectPicker;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;

public class ShoulderSurfingWthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.replacePicker((IObjectPicker)new ShoulderSurfingObjectPicker());
    }

    private static class ShoulderSurfingObjectPicker
    implements IObjectPicker {
        private ShoulderSurfingObjectPicker() {
        }

        public void pick(IPickerAccessor accessor, IPickerResults results, IPluginConfig config) {
            Minecraft minecraft = accessor.getClient();
            Camera camera = minecraft.f_91063_.m_109153_();
            if (ShoulderInstance.getInstance().doShoulderSurfing() && !Config.CLIENT.getCrosshairType().isDynamic() && camera.m_90592_() != null) {
                MultiPlayerGameMode gameMode = minecraft.f_91072_;
                ClipContext.Fluid fluidContext = config.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE;
                boolean traceEntities = config.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY);
                HitResult result = ShoulderHelper.traceBlocksAndEntities(camera, gameMode, accessor.getMaxDistance(), fluidContext, accessor.getFrameDelta(), traceEntities, true);
                results.add(result, 0.0);
            } else {
                ObjectPicker.INSTANCE.pick(accessor, results, config);
            }
        }
    }
}

