/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.mixins.CameraAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ShoulderRenderer {
    private static final ShoulderRenderer INSTANCE = new ShoulderRenderer();
    private static final Vector3f VECTOR_NEGATIVE_Y = new Vector3f(0.0f, -1.0f, 0.0f);
    private double cameraDistance;
    private Vec2f lastTranslation = Vec2f.ZERO;
    private Vec2f translation = Vec2f.ZERO;
    private Vec2f projected;

    public void offsetCrosshair(PoseStack poseStack, Window window, float partialTicks) {
        if (this.projected != null) {
            Vec2f scaledDimensions = new Vec2f(window.m_85445_(), window.m_85446_());
            Vec2f dimensions = new Vec2f(window.m_85443_(), window.m_85444_());
            Vec2f scale = scaledDimensions.divide(dimensions);
            Vec2f center = dimensions.divide(2.0f);
            Vec2f projectedOffset = this.projected.subtract(center).scale(scale);
            Vec2f interpolated = projectedOffset.subtract(this.lastTranslation).scale(partialTicks);
            this.translation = this.lastTranslation.add(interpolated);
        }
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing()) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_252922_().translate(this.translation.getX(), -this.translation.getY(), 0.0f);
            this.lastTranslation = this.translation;
        } else {
            this.lastTranslation = Vec2f.ZERO;
        }
    }

    public void clearCrosshairOffset(PoseStack poseStack) {
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing() && !Vec2f.ZERO.equals(this.lastTranslation)) {
            poseStack.m_85849_();
        }
    }

    public void offsetCamera(Camera camera, Level level, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing() && level != null) {
            LivingEntity living;
            Entity entity;
            ShoulderInstance instance = ShoulderInstance.getInstance();
            if (Config.CLIENT.doCenterCameraWhenClimbing() && (entity = camera.m_90592_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6147_()) {
                instance.setTargetOffsetX(0.0);
            } else if ((double)camera.m_253058_().angle((Vector3fc)VECTOR_NEGATIVE_Y) < Config.CLIENT.getCenterCameraWhenLookingDownAngle() * 0.01745329238474369) {
                instance.setTargetOffsetX(0.0);
                instance.setTargetOffsetY(0.0);
            } else if (Config.CLIENT.doDynamicallyAdjustOffsets()) {
                Vec3 localCameraOffset = new Vec3(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetZ());
                Vec3 worldCameraOffset = new Vec3(camera.m_253028_()).m_82490_(Config.CLIENT.getOffsetY()).m_82549_(new Vec3(camera.m_252775_()).m_82490_(Config.CLIENT.getOffsetX())).m_82549_(new Vec3(camera.m_253058_()).m_82490_(-Config.CLIENT.getOffsetZ())).m_82541_().m_82490_(localCameraOffset.m_82553_());
                Vec3 worldXYOffset = ShoulderHelper.calcRayTraceHeadOffset(camera, worldCameraOffset);
                Vec3 eyePosition = camera.m_90592_().m_20299_(partialTick);
                double absOffsetX = Math.abs(Config.CLIENT.getOffsetX());
                double absOffsetY = Math.abs(Config.CLIENT.getOffsetY());
                double absOffsetZ = Math.abs(Config.CLIENT.getOffsetZ());
                double targetX = absOffsetX;
                double targetY = absOffsetY;
                double clearance = (double)camera.m_90592_().m_20205_() / 3.0;
                for (double dz = 0.0; dz <= absOffsetZ; dz += 0.03125) {
                    double newTargetY;
                    Vec3 to;
                    double scale = dz / absOffsetZ;
                    Vec3 from = eyePosition.m_82549_(worldCameraOffset.m_82490_(scale));
                    ClipContext context = new ClipContext(from, to = eyePosition.m_82549_(worldXYOffset).m_82549_(new Vec3(camera.m_253058_()).m_82490_(-dz)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.m_90592_());
                    BlockHitResult hitResult = level.m_45547_(context);
                    if (hitResult.m_6662_() == HitResult.Type.MISS) continue;
                    double distance = hitResult.m_82450_().m_82554_(from);
                    double newTargetX = Math.max(distance + absOffsetX * scale - clearance, 0.0);
                    if (newTargetX < targetX) {
                        targetX = newTargetX;
                    }
                    if (!((newTargetY = Math.max(distance + absOffsetY * scale - clearance, 0.0)) < targetY)) continue;
                    targetY = newTargetY;
                }
                instance.setTargetOffsetX(Math.signum(Config.CLIENT.getOffsetX()) * targetX);
                instance.setTargetOffsetY(Math.signum(Config.CLIENT.getOffsetY()) * targetY);
                instance.setTargetOffsetZ(Config.CLIENT.getOffsetZ());
            } else {
                instance.setTargetOffsetX(Config.CLIENT.getOffsetX());
                instance.setTargetOffsetY(Config.CLIENT.getOffsetY());
                instance.setTargetOffsetZ(Config.CLIENT.getOffsetZ());
            }
            CameraAccessor accessor = (CameraAccessor)camera;
            double x = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19854_, (double)camera.m_90592_().m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19855_, (double)camera.m_90592_().m_20186_()) + (double)Mth.m_14179_((float)partialTick, (float)accessor.getEyeHeightOld(), (float)accessor.getEyeHeight());
            double z = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19856_, (double)camera.m_90592_().m_20189_());
            accessor.invokeSetPosition(x, y, z);
            double offsetX = Mth.m_14139_((double)partialTick, (double)instance.getOffsetXOld(), (double)instance.getOffsetX());
            double offsetY = Mth.m_14139_((double)partialTick, (double)instance.getOffsetYOld(), (double)instance.getOffsetY());
            double offsetZ = Mth.m_14139_((double)partialTick, (double)instance.getOffsetZOld(), (double)instance.getOffsetZ());
            Vec3 offset = new Vec3(-offsetZ, offsetY, offsetX);
            this.cameraDistance = this.calcCameraDistance(camera, level, accessor.invokeGetMaxZoom(offset.m_82553_()), partialTick);
            Vec3 scaled = offset.m_82541_().m_82490_(this.cameraDistance);
            accessor.invokeMove(scaled.f_82479_, scaled.f_82480_, scaled.f_82481_);
        }
    }

    private double calcCameraDistance(Camera camera, Level level, double distance, float partialTick) {
        Vec3 cameraPos = camera.m_90583_();
        Vec3 cameraOffset = ShoulderHelper.calcCameraOffset(camera, distance, partialTick);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3 to;
            Vec3 offset = new Vec3((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).m_82490_(2.0).m_82492_(1.0, 1.0, 1.0).m_82490_(0.075).m_82524_(-camera.m_90590_() * ((float)Math.PI / 180));
            Vec3 from = cameraPos.m_82549_(offset);
            ClipContext context = new ClipContext(from, to = from.m_82549_(cameraOffset), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.m_90592_());
            BlockHitResult hitResult = level.m_45547_(context);
            if (hitResult.m_6662_() == HitResult.Type.MISS || !((newDistance = hitResult.m_82450_().m_82554_(cameraPos)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    public void updateDynamicRaytrace(Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing()) {
            Minecraft minecraft = Minecraft.m_91087_();
            MultiPlayerGameMode gameMode = minecraft.f_91072_;
            HitResult hitResult = ShoulderHelper.traceBlocksAndEntities(camera, gameMode, this.getPlayerReach(), ClipContext.Fluid.NONE, partialTick, true, false);
            Vec3 position = hitResult.m_82450_().m_82546_(camera.m_90583_());
            this.projected = this.project2D(position, modelViewMatrix, projectionMatrix);
        }
    }

    @Nullable
    private Vec2f project2D(Vec3 position, Matrix4f modelView, Matrix4f projection) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_(), 1.0f);
        vec.mul((Matrix4fc)modelView);
        vec.mul((Matrix4fc)projection);
        if (vec.w() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.w() * 0.5f;
        float x = (vec.x() * w + 0.5f) * (float)screenWidth;
        float y = (vec.y() * w + 0.5f) * (float)screenHeight;
        float z = vec.z() * w + 0.5f;
        vec.set(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }

    public boolean skipEntityRendering() {
        return ShoulderInstance.getInstance().doShoulderSurfing() && (this.cameraDistance < (double)Minecraft.m_91087_().m_91288_().m_20205_() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)Minecraft.m_91087_().m_91288_().m_146909_() < Config.CLIENT.getCenterCameraWhenLookingDownAngle() - 90.0);
    }

    public double getPlayerReach() {
        return Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
    }

    public double getCameraDistance() {
        return this.cameraDistance;
    }

    public static ShoulderRenderer getInstance() {
        return INSTANCE;
    }
}

