/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Tab;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Label;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Widget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;

public abstract class SettingsTabBase<T extends ContainerScreen<?>>
extends Tab {
    private static final int RIGHT_BORDER_WIDTH = 6;
    private static final int BOTTOM_BORDER_HEIGHT = 7;
    protected final T screen;
    protected Dimension openTabDimension = new Dimension(0, 0);
    protected boolean isOpen = false;
    private Runnable onOpen;
    private Runnable onClose;
    private final List<Widget> hideableChildren;
    private final List<ITextProperties> openTooltip;

    protected SettingsTabBase(Position position, T screen, ITextComponent tabLabel, List<ITextProperties> tooltip, List<ITextProperties> openTooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position, tooltip, getTabButton);
        this.onOpen = () -> {};
        this.onClose = () -> {};
        this.hideableChildren = new ArrayList<Widget>();
        this.screen = screen;
        this.openTooltip = openTooltip;
        this.addLabel(tabLabel);
    }

    private void addLabel(ITextComponent tabLabel) {
        this.addHideableChild(new Label(new Position(this.x + 20, this.y + 8), tabLabel));
    }

    protected SettingsTabBase(Position position, T screen, ITextComponent tabLabel, ITextComponent tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position, tooltip, getTabButton);
        this.onOpen = () -> {};
        this.onClose = () -> {};
        this.hideableChildren = new ArrayList<Widget>();
        this.screen = screen;
        this.addLabel(tabLabel);
        this.openTooltip = Collections.emptyList();
    }

    protected <U extends Widget> U addHideableChild(U widget) {
        this.hideableChildren.add(widget);
        this.updateOpenTabDimension(widget);
        return widget;
    }

    private <U extends Widget> void updateOpenTabDimension(U widget) {
        int widgetMaxWidthExtension = widget.getX() + widget.getWidth() + 6 - this.x;
        int widgetMaxHeightExtension = widget.getY() + widget.getHeight() + 7 - this.y;
        this.openTabDimension = new Dimension(Math.max(this.openTabDimension.getWidth(), widgetMaxWidthExtension), Math.max(this.openTabDimension.getHeight(), widgetMaxHeightExtension));
    }

    public void setHandlers(Runnable onOpen, Runnable onClose, BooleanSupplier shouldRender, BooleanSupplier shouldShowTooltip) {
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.setHandlers(shouldShowTooltip, shouldRender);
    }

    @Override
    protected boolean isClosedTooltipVisible(int mouseX, int mouseY) {
        return !this.isOpen && super.isClosedTooltipVisible(mouseX, mouseY);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.openTooltip.isEmpty() && this.isOpenTooltipVisible(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(this.openTooltip);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private boolean isOpenTooltipVisible(int mouseX, int mouseY) {
        return this.isOpen && mouseX > this.x && mouseY > this.y + 3 && mouseX < this.x + 18 && mouseY < this.y + 21;
    }

    public void close() {
        this.setOpen(false);
        this.onTabClose();
    }

    protected void onTabOpen() {
        this.setWidth(this.openTabDimension.getWidth());
        this.setHeight(this.openTabDimension.getHeight());
        this.hideableChildren.forEach(this::addChild);
        this.onOpen.run();
    }

    protected void onTabClose() {
        this.setWidth(21);
        this.setHeight(24);
        this.children.removeAll(this.hideableChildren);
        this.onClose.run();
    }

    protected void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
        if (isOpen) {
            this.onTabOpen();
        } else {
            this.onTabClose();
        }
    }

    @Override
    protected void onTabIconClicked(int button) {
        if (button != 0) {
            return;
        }
        this.setOpen(!this.isOpen);
    }
}

