/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SettingsTabBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Tab;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Widget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class SettingsTabControl<C extends ContainerScreen<?>, T extends SettingsTabBase<C>>
extends CompositeWidget<Tab> {
    private static final int VERTICAL_SPACE = 1;
    @Nullable
    private T openTab = null;

    protected SettingsTabControl(Position position) {
        super(position);
    }

    protected <U extends T> U addSettingsTab(Runnable onTabOpenContainerAction, Runnable onTabCloseContainerAction, U tab) {
        SettingsTabBase settingsTab = (SettingsTabBase)((Object)this.addChild(tab));
        settingsTab.setHandlers(() -> {
            if (this.openTab != null && this.differentTabIsOpen(settingsTab)) {
                ((SettingsTabBase)((Object)((Object)this.openTab))).close();
            }
            settingsTab.setZOffset(200);
            this.openTab = settingsTab;
            onTabOpenContainerAction.run();
        }, () -> {
            if (this.openTab != null) {
                ((Widget)((Object)((Object)this.openTab))).setZOffset(0);
                this.openTab = null;
                onTabCloseContainerAction.run();
            }
        }, () -> this.openTab == null || !this.differentTabIsOpen(settingsTab) || this.isNotCovered(this.openTab, settingsTab, true), () -> this.openTab == null || this.isNotCovered(this.openTab, settingsTab, false));
        return (U)((Object)settingsTab);
    }

    private boolean isNotCovered(T open, Tab t, boolean checkFullyCovered) {
        if (checkFullyCovered) {
            return ((Tab)((Object)open)).getBottomY() < t.getBottomY() || ((Tab)((Object)open)).getTopY() > t.getTopY();
        }
        return ((Tab)((Object)open)).getBottomY() < t.getTopY() || ((Tab)((Object)open)).getTopY() > t.getTopY();
    }

    private boolean differentTabIsOpen(Tab tab) {
        return this.openTab != tab;
    }

    protected Optional<T> getOpenTab() {
        return Optional.ofNullable(this.openTab);
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    public void afterScreenRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.children.forEach(tab -> tab.afterScreenRender(matrixStack, mouseX, mouseY, partialTicks));
    }

    protected int getTopY() {
        return this.y + this.children.size() * 25;
    }

    @Override
    public int getHeight() {
        MutableInt maxY = new MutableInt(0);
        this.children.forEach(tab -> {
            int bottomY = tab.getBottomY();
            if (bottomY > maxY.getValue()) {
                maxY.setValue(bottomY);
            }
        });
        return maxY.getValue() - this.y;
    }

    @Override
    public int getWidth() {
        MutableInt maxWidth = new MutableInt(0);
        this.children.forEach(tab -> {
            int width = tab.getWidth();
            if (width > maxWidth.getValue()) {
                maxWidth.setValue(width);
            }
        });
        return maxWidth.getValue();
    }

    public List<Rectangle2d> getTabRectangles() {
        ArrayList<Rectangle2d> ret = new ArrayList<Rectangle2d>();
        this.children.forEach(child -> ret.add(child.getRectangle()));
        return ret;
    }
}

