/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;

public class Button
extends ButtonBase {
    private final TextureBlitData backgroundTexture;
    @Nullable
    private final TextureBlitData hoveredBackgroundTexture;
    @Nullable
    private final TextureBlitData foregroundTexture;
    private final List<ITextProperties> tooltip;

    public Button(Position position, ButtonDefinition buttonDefinition, IntConsumer onClick) {
        super(position, buttonDefinition.getDimension(), onClick);
        this.backgroundTexture = buttonDefinition.getBackgroundTexture();
        this.foregroundTexture = buttonDefinition.getForegroundTexture();
        this.hoveredBackgroundTexture = buttonDefinition.getHoveredBackgroundTexture();
        this.tooltip = Collections.singletonList(buttonDefinition.getTooltip());
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (this.hoveredBackgroundTexture != null) {
                GuiHelper.blit(minecraft, matrixStack, this.x, this.y, this.hoveredBackgroundTexture);
            }
        } else {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, this.backgroundTexture);
        }
    }

    @Override
    protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.foregroundTexture != null) {
            GuiHelper.blit(this.minecraft, matrixStack, this.x, this.y, this.foregroundTexture);
        }
        if (this.func_231047_b_(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(this.tooltip);
        }
    }
}

