/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = new ResourceLocation("sophisticatedbackpacks", "textures/gui/gui_controls.png");
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = new ResourceLocation("sophisticatedbackpacks", "textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();
    private static List<? extends ITextProperties> tooltipToRender = Collections.emptyList();

    private GuiHelper() {
    }

    public static void renderItemInGUI(MatrixStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(Minecraft minecraft, MatrixStack matrixStack, int x, int y, int slotWidth, int slotHeight) {
        int key = GuiHelper.getSlotsBackgroundKey(slotWidth, slotHeight);
        GuiHelper.blit(minecraft, matrixStack, x, y, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, slotHeight * 18))));
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(MatrixStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(MatrixStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        float originalZLevel = itemRenderer.field_77023_b;
        itemRenderer.field_77023_b += (float)GuiHelper.getZOffset(matrixStack);
        itemRenderer.func_180450_b(stack, xPosition, yPosition);
        if (renderOverlay) {
            itemRenderer.func_180453_a(minecraft.field_71466_p, stack, xPosition, yPosition, countText);
        }
        itemRenderer.field_77023_b = originalZLevel;
    }

    private static int getZOffset(MatrixStack matrixStack) {
        Float zOffset = (Float)ObfuscationReflectionHelper.getPrivateValue(Matrix4f.class, (Object)matrixStack.func_227866_c_().func_227870_a_(), (String)"field_226586_l_");
        return zOffset == null ? 0 : zOffset.intValue();
    }

    public static void blit(Minecraft minecraft, MatrixStack matrixStack, int x, int y, TextureBlitData texData) {
        minecraft.func_110434_K().func_110577_a(texData.getTextureName());
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset()), (float)texData.getU(), (float)texData.getV(), (int)texData.getWidth(), (int)texData.getHeight(), (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)xMin, (float)yMax, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)xMax, (float)yMax, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)xMax, (float)yMin, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)xMin, (float)yMin, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void setTooltipToRender(List<? extends ITextProperties> tooltip) {
        tooltipToRender = tooltip;
    }

    public static void renderTooltip(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (tooltipToRender.isEmpty()) {
            return;
        }
        GuiHelper.renderTooltip(minecraft, matrixStack, tooltipToRender, mouseX, mouseY, ITooltipRenderPart.EMPTY, null, ItemStack.field_190927_a, 150);
        tooltipToRender = Collections.emptyList();
    }

    public static void renderTooltip(Minecraft minecraft, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, ITooltipRenderPart additionalRender, @Nullable FontRenderer tooltipRenderFont, ItemStack stack) {
        GuiHelper.renderTooltip(minecraft, matrixStack, textLines, mouseX, mouseY, additionalRender, tooltipRenderFont, stack, 0);
    }

    public static void renderTooltip(Minecraft minecraft, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, ITooltipRenderPart additionalRender, @Nullable FontRenderer tooltipRenderFont, ItemStack stack, int maxTextWidth) {
        int leftX;
        FontRenderer font = tooltipRenderFont == null ? minecraft.field_71466_p : tooltipRenderFont;
        int windowWidth = minecraft.func_228018_at_().func_198107_o();
        int windowHeight = minecraft.func_228018_at_().func_198087_p();
        int tooltipWidth = GuiHelper.getMaxLineWidth(textLines, font);
        tooltipWidth = Math.max(tooltipWidth, additionalRender.getWidth());
        boolean needsWrap = false;
        if (maxTextWidth > 0 && tooltipWidth > maxTextWidth) {
            tooltipWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (ITextProperties iTextProperties : textLines) {
                List wrappedLine = font.func_238420_b_().func_238362_b_(iTextProperties, tooltipWidth, Style.field_240709_b_);
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
        }
        if ((leftX = mouseX + 12) + tooltipWidth > windowWidth) {
            leftX -= 28 + tooltipWidth;
        }
        int topY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += 2 + (textLines.size() - 1) * 10;
        }
        if (topY + (tooltipHeight += additionalRender.getHeight()) + 6 > windowHeight) {
            topY = windowHeight - tooltipHeight - 6;
        }
        int n = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, matrixStack, leftX, topY, font, n, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        int n2 = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        matrixStack.func_227860_a_();
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, leftX, topY, tooltipHeight, n2, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, matrixStack, leftX, topY, font, tooltipWidth, tooltipHeight));
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        topY = GuiHelper.writeTooltipLines(textLines, font, leftX, topY, matrix4f, renderTypeBuffer, -1);
        renderTypeBuffer.func_228461_a_();
        additionalRender.render(matrixStack, leftX, topY, font);
        matrixStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, matrixStack, leftX, topY, font, tooltipWidth, tooltipHeight));
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, 400, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, 400, borderColorEnd, borderColorEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private static int getMaxLineWidth(List<? extends ITextProperties> tooltips, FontRenderer font) {
        int maxLineWidth = 0;
        for (ITextProperties iTextProperties : tooltips) {
            int lineWidth = font.func_238414_a_(iTextProperties);
            if (lineWidth <= maxLineWidth) continue;
            maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }

    public static int writeTooltipLines(List<? extends ITextProperties> textLines, FontRenderer font, float leftX, int topY, Matrix4f matrix4f, IRenderTypeBuffer.Impl renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            ITextProperties line = textLines.get(i);
            if (line != null) {
                font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), leftX, (float)topY, color, true, matrix4f, (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
        return topY;
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_227885_a_(f1, f2, f3, f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_227885_a_(f1, f2, f3, f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_227885_a_(f5, f6, f7, f4).func_181675_d();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, ITextComponent ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new ITextComponent[]{new TranslationTextComponent(tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<? extends ITextComponent> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(Minecraft minecraft, MatrixStack matrixStack, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(minecraft, matrixStack, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static interface ITooltipRenderPart {
        public static final ITooltipRenderPart EMPTY = new ITooltipRenderPart(){

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 0;
            }

            @Override
            public void render(MatrixStack matrixStack, int leftX, int topY, FontRenderer font) {
            }
        };

        public int getWidth();

        public int getHeight();

        public void render(MatrixStack var1, int var2, int var3, FontRenderer var4);
    }
}

