/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class SmeltingLogic {
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private ItemStackHandler smeltingInventory = null;
    public static final int COOK_INPUT_SLOT = 0;
    public static final int COOK_OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 1;
    @Nullable
    private FurnaceRecipe smeltingRecipe = null;
    private boolean smeltingRecipeInitialized = false;
    private final Predicate<ItemStack> isFuel;
    private final Predicate<ItemStack> isInput;
    private final double smeltingSpeedMultiplier;
    private final double fuelEfficiencyMultiplier;

    public SmeltingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, double smeltingSpeedMultiplier, double fuelEfficiencyMultiplier) {
        this(upgrade, saveHandler, s -> SmeltingLogic.getBurnTime(s) > 0, s -> RecipeHelper.getSmeltingRecipe(s).isPresent(), smeltingSpeedMultiplier, fuelEfficiencyMultiplier);
    }

    public SmeltingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, Predicate<ItemStack> isFuel, Predicate<ItemStack> isInput, double smeltingSpeedMultiplier, double fuelEfficiencyMultiplier) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.isFuel = isFuel;
        this.isInput = isInput;
        this.smeltingSpeedMultiplier = smeltingSpeedMultiplier;
        this.fuelEfficiencyMultiplier = fuelEfficiencyMultiplier;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean tick(World world) {
        AtomicBoolean didSomething = new AtomicBoolean(true);
        if (this.isBurning(world) || this.readyToStartCooking()) {
            Optional<FurnaceRecipe> fr = this.getSmeltingRecipe();
            if (!fr.isPresent() && this.isCooking()) {
                this.setIsCooking(false);
            }
            fr.ifPresent(recipe -> {
                this.updateFuel(world, (FurnaceRecipe)recipe);
                if (this.isBurning(world) && this.canSmelt((IRecipe<?>)recipe)) {
                    this.updateCookingProgress(world, (FurnaceRecipe)recipe);
                } else if (!this.isBurning(world)) {
                    didSomething.set(false);
                }
            });
        }
        if (!this.isBurning(world) && this.isCooking()) {
            this.updateCookingCooldown(world);
        } else {
            didSomething.set(false);
        }
        return didSomething.get();
    }

    public boolean isBurning(World world) {
        return this.getBurnTimeFinish() >= world.func_82737_E();
    }

    private Optional<FurnaceRecipe> getSmeltingRecipe() {
        if (!this.smeltingRecipeInitialized) {
            this.smeltingRecipe = RecipeHelper.getSmeltingRecipe(this.getCookInput()).orElse(null);
            this.smeltingRecipeInitialized = true;
        }
        return Optional.ofNullable(this.smeltingRecipe);
    }

    private void updateCookingCooldown(World world) {
        if (this.getRemainingCookTime(world) + 2 > this.getCookTimeTotal()) {
            this.setIsCooking(false);
        } else {
            this.setCookTimeFinish(world.func_82737_E() + (long)Math.min(this.getRemainingCookTime(world) + 2, this.getCookTimeTotal()));
        }
    }

    private void updateCookingProgress(World world, FurnaceRecipe smeltingRecipe) {
        if (this.isCooking() && this.finishedCooking(world)) {
            this.smelt((IRecipe<?>)smeltingRecipe);
            if (this.canSmelt((IRecipe<?>)smeltingRecipe)) {
                this.setCookTime(world, (int)((double)smeltingRecipe.func_222137_e() * (1.0 / this.smeltingSpeedMultiplier)));
            } else {
                this.setIsCooking(false);
            }
        } else if (!this.isCooking()) {
            this.setIsCooking(true);
            this.setCookTime(world, (int)((double)smeltingRecipe.func_222137_e() * (1.0 / this.smeltingSpeedMultiplier)));
        }
    }

    private boolean finishedCooking(World world) {
        return this.getCookTimeFinish() <= world.func_82737_E();
    }

    private boolean readyToStartCooking() {
        return !this.getFuel().func_190926_b() && !this.getCookInput().func_190926_b();
    }

    private void smelt(IRecipe<?> recipe) {
        if (!this.canSmelt(recipe)) {
            return;
        }
        ItemStack input = this.getCookInput();
        ItemStack recipeOutput = recipe.func_77571_b();
        ItemStack output = this.getCookOutput();
        if (output.func_190926_b()) {
            this.setCookOutput(recipeOutput.func_77946_l());
        } else if (output.func_77973_b() == recipeOutput.func_77973_b()) {
            output.func_190917_f(recipeOutput.func_190916_E());
            this.setCookOutput(output);
        }
        if (input.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !this.getFuel().func_190926_b() && this.getFuel().func_77973_b() == Items.field_151133_ar) {
            this.setFuel(new ItemStack((IItemProvider)Items.field_151131_as));
        }
        input.func_190918_g(1);
        this.setCookInput(input);
    }

    public void setCookInput(ItemStack input) {
        this.smeltingInventory.setStackInSlot(0, input);
    }

    private void setCookOutput(ItemStack stack) {
        this.getSmeltingInventory().setStackInSlot(2, stack);
    }

    private int getRemainingCookTime(World world) {
        return (int)(this.getCookTimeFinish() - world.func_82737_E());
    }

    private void setCookTime(World world, int cookTime) {
        this.setCookTimeFinish(world.func_82737_E() + (long)cookTime);
        this.setCookTimeTotal(cookTime);
    }

    private void updateFuel(World world, FurnaceRecipe smeltingRecipe) {
        ItemStack fuel = this.getFuel();
        if (!this.isBurning(world) && this.canSmelt((IRecipe<?>)smeltingRecipe)) {
            if (SmeltingLogic.getBurnTime(fuel) <= 0) {
                return;
            }
            this.setBurnTime(world, (int)((double)SmeltingLogic.getBurnTime(fuel) * this.fuelEfficiencyMultiplier / this.smeltingSpeedMultiplier));
            if (this.isBurning(world)) {
                if (fuel.hasContainerItem()) {
                    this.setFuel(fuel.getContainerItem());
                } else if (!fuel.func_190926_b()) {
                    fuel.func_190918_g(1);
                    this.setFuel(fuel);
                    if (fuel.func_190926_b()) {
                        this.setFuel(fuel.getContainerItem());
                    }
                }
            }
        }
    }

    private void setBurnTime(World world, int burnTime) {
        this.setBurnTimeFinish(world.func_82737_E() + (long)burnTime);
        this.setBurnTimeTotal(burnTime);
    }

    protected boolean canSmelt(IRecipe<?> smeltingRecipe) {
        if (this.getCookInput().func_190926_b()) {
            return false;
        }
        ItemStack recipeOutput = smeltingRecipe.func_77571_b();
        if (recipeOutput.func_190926_b()) {
            return false;
        }
        ItemStack output = this.getCookOutput();
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(recipeOutput)) {
            return false;
        }
        if (output.func_190916_E() + recipeOutput.func_190916_E() <= 64 && output.func_190916_E() + recipeOutput.func_190916_E() <= output.func_77976_d()) {
            return true;
        }
        return output.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
    }

    private static int getBurnTime(ItemStack fuel) {
        return ForgeHooks.getBurnTime((ItemStack)fuel);
    }

    public ItemStack getCookOutput() {
        return this.getSmeltingInventory().getStackInSlot(2);
    }

    public ItemStack getCookInput() {
        return this.getSmeltingInventory().getStackInSlot(0);
    }

    public ItemStack getFuel() {
        return this.getSmeltingInventory().getStackInSlot(1);
    }

    public void setFuel(ItemStack fuel) {
        this.getSmeltingInventory().setStackInSlot(1, fuel);
    }

    public ItemStackHandler getSmeltingInventory() {
        if (this.smeltingInventory == null) {
            this.smeltingInventory = new ItemStackHandler(3){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    SmeltingLogic.this.upgrade.func_77983_a("smeltingInventory", (INBT)this.serializeNBT());
                    SmeltingLogic.this.save();
                    if (slot == 0) {
                        SmeltingLogic.this.smeltingRecipeInitialized = false;
                    }
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    switch (slot) {
                        case 0: {
                            return SmeltingLogic.this.isInput.test(stack);
                        }
                        case 1: {
                            return SmeltingLogic.this.isFuel.test(stack);
                        }
                    }
                    return true;
                }
            };
            NBTHelper.getCompound(this.upgrade, "smeltingInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.smeltingInventory).deserializeNBT(arg_0));
        }
        return this.smeltingInventory;
    }

    public long getBurnTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "burnTimeFinish").orElse(0L);
    }

    private void setBurnTimeFinish(long burnTimeFinish) {
        NBTHelper.setLong(this.upgrade, "burnTimeFinish", burnTimeFinish);
        this.save();
    }

    public int getBurnTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "burnTimeTotal").orElse(0);
    }

    private void setBurnTimeTotal(int burnTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "burnTimeTotal", burnTimeTotal);
        this.save();
    }

    public long getCookTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "cookTimeFinish").orElse(-1L);
    }

    private void setCookTimeFinish(long cookTimeFinish) {
        NBTHelper.setLong(this.upgrade, "cookTimeFinish", cookTimeFinish);
        this.save();
    }

    public int getCookTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "cookTimeTotal").orElse(0);
    }

    private void setCookTimeTotal(int cookTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "cookTimeTotal", cookTimeTotal);
        this.save();
    }

    public boolean isCooking() {
        return NBTHelper.getBoolean(this.upgrade, "isCooking").orElse(false);
    }

    private void setIsCooking(boolean isCooking) {
        NBTHelper.setBoolean(this.upgrade, "isCooking", isCooking);
        this.save();
    }
}

