/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolFilterSlot;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperFilterLogic;
import org.apache.commons.lang3.StringUtils;

public class ToolSwapperFilterContainer
extends FilterLogicContainerBase<ToolSwapperFilterLogic, ToolFilterSlot> {
    private static final Set<String> AVAILABLE_TOOL_BACKGROUNDS = ImmutableSet.of((Object)"axe", (Object)"hammer", (Object)"pickaxe", (Object)"shovel", (Object)"hoe");
    public static final ResourceLocation EMPTY_WEAPON_SLOT_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "item/empty_weapon_slot");
    public static final Map<ToolType, ResourceLocation> EMPTY_TOOL_SLOT_BACKGROUNDS;

    public ToolSwapperFilterContainer(IServerUpdater serverUpdater, Supplier<ToolSwapperFilterLogic> filterLogic, Consumer<Slot> addSlot) {
        super(serverUpdater, filterLogic);
        ToolFilterSlot weaponFilterSlot = new ToolFilterSlot(() -> ((ToolSwapperFilterLogic)filterLogic.get()).getWeaponFilter(), stack -> ((ToolSwapperFilterLogic)filterLogic.get()).setWeaponFilter((ItemStack)stack), s -> true);
        weaponFilterSlot.setBackground(PlayerContainer.field_226615_c_, EMPTY_WEAPON_SLOT_BACKGROUND);
        this.filterSlots.add(weaponFilterSlot);
        filterLogic.get().getToolFilterTypes().forEach(toolType -> {
            ToolFilterSlot toolFilterSlot = new ToolFilterSlot(() -> ToolSwapperFilterContainer.lambda$new$3((Supplier)filterLogic, toolType), arg_0 -> ToolSwapperFilterContainer.lambda$new$4((Supplier)filterLogic, toolType, arg_0), s -> s.getToolTypes().contains(toolType));
            if (EMPTY_TOOL_SLOT_BACKGROUNDS.containsKey(toolType)) {
                toolFilterSlot.setBackground(PlayerContainer.field_226615_c_, EMPTY_TOOL_SLOT_BACKGROUNDS.get(toolType));
            }
            toolFilterSlot.setEmptyTooltip(StringUtils.capitalize((String)toolType.getName()));
            this.filterSlots.add(toolFilterSlot);
        });
        this.filterSlots.forEach(addSlot);
    }

    private static /* synthetic */ void lambda$new$4(Supplier filterLogic, ToolType toolType, ItemStack stack) {
        ((ToolSwapperFilterLogic)filterLogic.get()).setToolFilter(toolType, stack);
    }

    private static /* synthetic */ ItemStack lambda$new$3(Supplier filterLogic, ToolType toolType) {
        return ((ToolSwapperFilterLogic)filterLogic.get()).getToolFilter(toolType);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String template = "item/empty_%s_slot";
        for (ToolType toolType : ToolRegistry.getToolTypes().values()) {
            if (!AVAILABLE_TOOL_BACKGROUNDS.contains(toolType.getName())) continue;
            builder.put((Object)toolType, (Object)new ResourceLocation("sophisticatedbackpacks", String.format(template, toolType.getName())));
        }
        EMPTY_TOOL_SLOT_BACKGROUNDS = builder.build();
    }
}

