/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    private static final String SETTINGS = " Settings";
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair clientSpec = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
        Pair commonSpec = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<SortButtonsPosition> sortButtonsPosition;
        public final ForgeConfigSpec.BooleanValue playButtonSound;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.sortButtonsPosition = builder.comment("Positions where sort buttons can display to help with conflicts with controls from other mods").defineEnum("sortButtonsPosition", (Enum)SortButtonsPosition.TITLE_LINE_RIGHT);
            this.playButtonSound = builder.comment("Whether click sound should play when custom buttons are clicked in backpack gui").define("playButtonSound", true);
            builder.pop();
        }
    }

    public static class Common {
        public final EnabledItems enabledItems;
        public final BackpackConfig leatherBackpack;
        public final BackpackConfig ironBackpack;
        public final BackpackConfig goldBackpack;
        public final BackpackConfig diamondBackpack;
        public final BackpackConfig netheriteBackpack;
        public final FilteredUpgradeConfig compactingUpgrade;
        public final FilteredUpgradeConfig advancedCompactingUpgrade;
        public final FilteredUpgradeConfig depositUpgrade;
        public final FilteredUpgradeConfig advancedDepositUpgrade;
        public final FilteredUpgradeConfig feedingUpgrade;
        public final FilteredUpgradeConfig advancedFeedingUpgrade;
        public final FilteredUpgradeConfig filterUpgrade;
        public final FilteredUpgradeConfig advancedFilterUpgrade;
        public final MagnetUpgradeConfig magnetUpgrade;
        public final MagnetUpgradeConfig advancedMagnetUpgrade;
        public final FilteredUpgradeConfig pickupUpgrade;
        public final FilteredUpgradeConfig advancedPickupUpgrade;
        public final FilteredUpgradeConfig refillUpgrade;
        public final FilteredUpgradeConfig restockUpgrade;
        public final FilteredUpgradeConfig advancedRestockUpgrade;
        public final FilteredUpgradeConfig voidUpgrade;
        public final FilteredUpgradeConfig advancedVoidUpgrade;
        public final SmeltingUpgradeConfig smeltingUpgrade;
        public final AutoSmeltingUpgradeConfig autoSmeltingUpgrade;
        public final InceptionUpgradeConfig inceptionUpgrade;
        public final EntityBackpackAdditionsConfig entityBackpackAdditions;
        public final ForgeConfigSpec.BooleanValue chestLootEnabled;
        public final FilteredUpgradeConfig toolSwapperUpgrade;
        public final TankUpgradeConfig tankUpgrade;
        public final BatteryUpgradeConfig batteryUpgrade;

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.enabledItems.enabledMap.clear();
        }

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.enabledItems = new EnabledItems(builder);
            this.leatherBackpack = new BackpackConfig(builder, "Leather", 27, 1);
            this.ironBackpack = new BackpackConfig(builder, "Iron", 54, 2);
            this.goldBackpack = new BackpackConfig(builder, "Gold", 81, 3);
            this.diamondBackpack = new BackpackConfig(builder, "Diamond", 108, 5);
            this.netheriteBackpack = new BackpackConfig(builder, "Netherite", 120, 7);
            this.compactingUpgrade = new FilteredUpgradeConfig(builder, "Compacting Upgrade", "compactingUpgrade", 9, 3);
            this.advancedCompactingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Compacting Upgrade", "advancedCompactingUpgrade", 16, 4);
            this.depositUpgrade = new FilteredUpgradeConfig(builder, "Deposit Upgrade", "depositUpgrade", 9, 3);
            this.advancedDepositUpgrade = new FilteredUpgradeConfig(builder, "Advanced Deposit Upgrade", "advancedDepositUpgrade", 16, 4);
            this.feedingUpgrade = new FilteredUpgradeConfig(builder, "Feeding Upgrade", "feedingUpgrade", 9, 3);
            this.advancedFeedingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Feeding Upgrade", "advancedFeedingUpgrade", 16, 4);
            this.filterUpgrade = new FilteredUpgradeConfig(builder, "Filter Upgrade", "filterUpgrade", 9, 3);
            this.advancedFilterUpgrade = new FilteredUpgradeConfig(builder, "Advanced Filter Upgrade", "advancedFilterUpgrade", 16, 4);
            this.magnetUpgrade = new MagnetUpgradeConfig(builder, "Magnet Upgrade", "magnetUpgrade", 9, 3, 3);
            this.advancedMagnetUpgrade = new MagnetUpgradeConfig(builder, "Advanced Magnet Upgrade", "advancedMagnetUpgrade", 16, 4, 5);
            this.pickupUpgrade = new FilteredUpgradeConfig(builder, "Pickup Upgrade", "pickupUpgrade", 9, 3);
            this.advancedPickupUpgrade = new FilteredUpgradeConfig(builder, "Advanced Pickup Upgrade", "advancedPickupUpgrade", 16, 4);
            this.refillUpgrade = new FilteredUpgradeConfig(builder, "Refill Upgrade", "refillUpgrade", 6, 3);
            this.restockUpgrade = new FilteredUpgradeConfig(builder, "Restock Upgrade", "restockUpgrade", 9, 3);
            this.advancedRestockUpgrade = new FilteredUpgradeConfig(builder, "Advanced Restock Upgrade", "advancedRestockUpgrade", 16, 4);
            this.voidUpgrade = new FilteredUpgradeConfig(builder, "Void Upgrade", "voidUpgrade", 9, 3);
            this.advancedVoidUpgrade = new FilteredUpgradeConfig(builder, "Advanced Void Upgrade", "advancedVoidUpgrade", 16, 4);
            this.smeltingUpgrade = new SmeltingUpgradeConfig(builder);
            this.autoSmeltingUpgrade = new AutoSmeltingUpgradeConfig(builder);
            this.inceptionUpgrade = new InceptionUpgradeConfig(builder);
            this.toolSwapperUpgrade = new FilteredUpgradeConfig(builder, "Tool Swapper Upgrade", "toolSwapperUpgrade", 8, 4);
            this.tankUpgrade = new TankUpgradeConfig(builder);
            this.batteryUpgrade = new BatteryUpgradeConfig(builder);
            this.entityBackpackAdditions = new EntityBackpackAdditionsConfig(builder);
            this.chestLootEnabled = builder.comment("Turns on/off loot added to various vanilla chest loot tables").define("chestLootEnabled", true);
            builder.pop();
        }

        public static class EnabledItems {
            private final ForgeConfigSpec.ConfigValue<List<String>> itemsEnableList;
            private final Map<String, Boolean> enabledMap = new ConcurrentHashMap<String, Boolean>();

            EnabledItems(ForgeConfigSpec.Builder builder) {
                this.itemsEnableList = builder.comment("Disable / enable any items here (disables their recipes)").define("enabledItems", new ArrayList());
            }

            public boolean isItemEnabled(Item item) {
                return RegistryHelper.getRegistryName(item).map(rn -> this.isItemEnabled(rn.m_135815_())).orElse(false);
            }

            public boolean isItemEnabled(String itemRegistryName) {
                if (!COMMON_SPEC.isLoaded()) {
                    return true;
                }
                if (this.enabledMap.isEmpty()) {
                    this.loadEnabledMap();
                }
                return this.enabledMap.computeIfAbsent(itemRegistryName, irn -> {
                    this.addEnabledItemToConfig(itemRegistryName);
                    return true;
                });
            }

            private void addEnabledItemToConfig(String itemRegistryName) {
                ((List)this.itemsEnableList.get()).add(itemRegistryName + ":true");
                COMMON_SPEC.save();
            }

            private void loadEnabledMap() {
                for (String itemEnabled : (List)this.itemsEnableList.get()) {
                    String[] data = itemEnabled.split(":");
                    if (data.length == 2) {
                        this.enabledMap.put(data[0], Boolean.valueOf(data[1]));
                        continue;
                    }
                    SophisticatedBackpacks.LOGGER.error("Wrong data for enabledItems - expected name:true/false when {} was provided", (Object)itemEnabled);
                }
            }
        }

        public static class BackpackConfig {
            public final ForgeConfigSpec.IntValue inventorySlotCount;
            public final ForgeConfigSpec.IntValue upgradeSlotCount;

            public BackpackConfig(ForgeConfigSpec.Builder builder, String backpackPrefix, int inventorySlotCountDefault, int upgradeSlotCountDefault) {
                builder.comment(backpackPrefix + " Backpack Settings").push(backpackPrefix.toLowerCase(Locale.ENGLISH) + "Backpack");
                this.inventorySlotCount = builder.comment("Number of inventory slots in the backpack").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 144);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the backpack").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }
        }

        public static class FilteredUpgradeConfig
        extends FilteredUpgradeConfigBase {
            public FilteredUpgradeConfig(ForgeConfigSpec.Builder builder, String name, String path, int defaultFilterSlots, int defaultSlotsInRow) {
                super(builder, name, path, defaultFilterSlots, defaultSlotsInRow);
                builder.pop();
            }
        }

        public static class MagnetUpgradeConfig
        extends FilteredUpgradeConfigBase {
            public final ForgeConfigSpec.IntValue magnetRange;

            public MagnetUpgradeConfig(ForgeConfigSpec.Builder builder, String name, String path, int defaultFilterSlots, int defaultSlotsInRow, int defaultMagnetRange) {
                super(builder, name, path, defaultFilterSlots, defaultSlotsInRow);
                this.magnetRange = builder.comment("Range around backpack in blocks at which magnet will pickup items").defineInRange("magnetRange", defaultMagnetRange, 1, 20);
                builder.pop();
            }
        }

        public static class SmeltingUpgradeConfig
        extends SmeltingUpgradeConfigBase {
            public SmeltingUpgradeConfig(ForgeConfigSpec.Builder builder) {
                super(builder, "Smelting Upgrade", "smeltingUpgrade");
                builder.pop();
            }
        }

        public static class AutoSmeltingUpgradeConfig
        extends SmeltingUpgradeConfigBase {
            public final ForgeConfigSpec.IntValue inputFilterSlots;
            public final ForgeConfigSpec.IntValue inputFilterSlotsInRow;
            public final ForgeConfigSpec.IntValue fuelFilterSlots;
            public final ForgeConfigSpec.IntValue fuelFilterSlotsInRow;

            public AutoSmeltingUpgradeConfig(ForgeConfigSpec.Builder builder) {
                super(builder, "Auto-Smelting Upgrade", "autoSmeltingUpgrade");
                this.inputFilterSlots = builder.comment("Number of input filter slots").defineInRange("inputFilterSlots", 8, 1, 20);
                this.inputFilterSlotsInRow = builder.comment("Number of input filter slots displayed in a row").defineInRange("inputFilterSlotsInRow", 4, 1, 6);
                this.fuelFilterSlots = builder.comment("Number of fuel filter slots").defineInRange("fuelFilterSlots", 4, 1, 20);
                this.fuelFilterSlotsInRow = builder.comment("Number of fuel filter slots displayed in a row").defineInRange("fuelFilterSlotsInRow", 4, 1, 6);
                builder.pop();
            }
        }

        public static class InceptionUpgradeConfig {
            public final ForgeConfigSpec.BooleanValue upgradesUseInventoriesOfBackpacksInBackpack;
            public final ForgeConfigSpec.BooleanValue upgradesInContainedBackpacksAreFunctional;

            public InceptionUpgradeConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Inception Upgrade Settings").push("inceptionUpgrade");
                this.upgradesUseInventoriesOfBackpacksInBackpack = builder.comment("Allows / Disallows backpack upgrades to work with inventories of Backpacks in the Backpack with Inception Upgrade").define("upgradesUseInventoriesOfBackpacksInBackpack", true);
                this.upgradesInContainedBackpacksAreFunctional = builder.comment("Allows / Disallows upgrades to be functional even when they are in Backpacks in the inventory of Backpack with Inception Upgrade").define("upgradesInContainedBackpacksAreFunctional", true);
                builder.pop();
            }
        }

        public static class TankUpgradeConfig {
            public final ForgeConfigSpec.IntValue capacityPerSlotRow;
            public final ForgeConfigSpec.DoubleValue stackMultiplierRatio;
            public final ForgeConfigSpec.IntValue autoFillDrainContainerCooldown;
            public final ForgeConfigSpec.IntValue maxInputOutput;

            protected TankUpgradeConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Tank Upgrade Settings").push("tankUpgrade");
                this.capacityPerSlotRow = builder.comment("Capacity in mB the tank upgrade will have per row of backpack slots").defineInRange("capacityPerSlotRow", 2000, 500, 20000);
                this.stackMultiplierRatio = builder.comment("Ratio that gets applied (multiplies) to inventory stack multiplier before this is applied to tank capacity. Value lower than 1 makes stack multiplier affect the capacity less, higher makes it affect the capacity more. 0 turns off stack multiplier affecting tank capacity").defineInRange("stackMultiplierRatio", 1.0, 0.0, 5.0);
                this.autoFillDrainContainerCooldown = builder.comment("Cooldown between fill/drain actions done on fluid containers in tank slots. Only fills/drains one bucket worth to/from container after this cooldown and then waits again.").defineInRange("autoFillDrainContainerCooldown", 20, 1, 100);
                this.maxInputOutput = builder.comment("How much mB can be transfered in / out per operation. This is a base transfer rate and same as max tank capacity gets multiplied by number of rows in backpack and stack multiplier.").defineInRange("maxInputOutput", 20, 1, 1000);
                builder.pop();
            }
        }

        public static class BatteryUpgradeConfig {
            public final ForgeConfigSpec.IntValue energyPerSlotRow;
            public final ForgeConfigSpec.DoubleValue stackMultiplierRatio;
            public final ForgeConfigSpec.IntValue maxInputOutput;

            protected BatteryUpgradeConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Tank Upgrade Settings").push("tankUpgrade");
                this.energyPerSlotRow = builder.comment("Energy in FE the battery upgrade will have per row of backpack slots").defineInRange("energyPerSlotRow", 10000, 500, 50000);
                this.stackMultiplierRatio = builder.comment("Ratio that gets applied (multiplies) to inventory stack multiplier before this is applied to max energy of the battery and max in/out. Value lower than 1 makes stack multiplier affect the max energy less, higher makes it affect the max energy more. 0 turns off stack multiplier affecting battery upgrade").defineInRange("stackMultiplierRatio", 1.0, 0.0, 5.0);
                this.maxInputOutput = builder.comment("How much FE can be transfered in / out per operation. This is a base transfer rate and same as max storage gets multiplied by number of rows in backpack and stack multiplier.").defineInRange("maxInputOutput", 20, 1, 1000);
                builder.pop();
            }
        }

        public static class EntityBackpackAdditionsConfig {
            private static final String REGISTRY_NAME_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)";
            private static final String ENTITY_LOOT_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)\\|(null|[a-z1-9_.-]+:[a-z1-9/_.-]+)";
            public final ForgeConfigSpec.DoubleValue chance;
            public final ForgeConfigSpec.BooleanValue addLoot;
            public final ForgeConfigSpec.BooleanValue buffWithPotionEffects;
            public final ForgeConfigSpec.BooleanValue buffHealth;
            public final ForgeConfigSpec.BooleanValue equipWithArmor;
            public final ForgeConfigSpec.BooleanValue playJukebox;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityLootTableList;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> discBlockList;
            @Nullable
            private Map<EntityType<?>, ResourceLocation> entityLootTables = null;

            public EntityBackpackAdditionsConfig(ForgeConfigSpec.Builder builder) {
                builder.comment("Settings for Spawning Entities with Backpack").push("entityBackpackAdditions");
                this.chance = builder.comment("Chance of an entity spawning with Backpack").defineInRange("chance", 0.01, 0.0, 1.0);
                this.addLoot = builder.comment("Turns on/off addition of loot into backpacks").define("addLoot", true);
                this.buffWithPotionEffects = builder.comment("Turns on/off buffing the entity that wears backpack with potion effects. These are scaled based on how much loot is added.").define("buffWithPotionEffects", true);
                this.buffHealth = builder.comment("Turns on/off buffing the entity that wears backpack with additional health. Health is scaled based on backpack tier the mob wears.").define("buffHealth", true);
                this.equipWithArmor = builder.comment("Turns on/off equiping the entity that wears backpack with armor. What armor material and how enchanted is scaled based on backpack tier the mob wears.").define("equipWithArmor", true);
                this.entityLootTableList = builder.comment("Map of entities that can spawn with backpack and related loot tables (if adding a loot is enabled) in format of \"EntityRegistryName|LootTableName\"").defineList("entityLootTableList", this::getDefaultEntityLootTableList, mapping -> ((String)mapping).matches(ENTITY_LOOT_MATCHER));
                this.discBlockList = builder.comment("List of music discs that are not supposed to be played by entities").defineList("discBlockList", this::getDefaultDiscBlockList, mapping -> ((String)mapping).matches(REGISTRY_NAME_MATCHER));
                this.playJukebox = builder.comment("Turns on/off a chance that the entity that wears backpack gets jukebox upgrade and plays a music disc.").define("playJukebox", true);
                builder.pop();
            }

            public Optional<ResourceLocation> getLootTableName(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return Optional.ofNullable(this.entityLootTables.get(entityType));
            }

            public boolean canWearBackpack(EntityType<?> entityType) {
                if (this.entityLootTables == null) {
                    this.initEntityLootTables();
                }
                return this.entityLootTables.containsKey(entityType);
            }

            private void initEntityLootTables() {
                this.entityLootTables = new HashMap();
                for (String mapping : (List)this.entityLootTableList.get()) {
                    String[] entityLoot = mapping.split("\\|");
                    if (entityLoot.length < 2) continue;
                    String entityRegistryName = entityLoot[0];
                    String lootTableName = entityLoot[1];
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityRegistryName));
                    if (entityType == null) continue;
                    this.entityLootTables.put(entityType, lootTableName.equals("null") ? null : new ResourceLocation(lootTableName));
                }
            }

            private List<String> getDefaultDiscBlockList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("botania:record_gaia_1");
                ret.add("botania:record_gaia_2");
                return ret;
            }

            private List<String> getDefaultEntityLootTableList() {
                return this.getDefaultEntityLootMapping().entrySet().stream().map(e -> ((EntityType)e.getKey()).getRegistryName() + "|" + e.getValue()).collect(Collectors.toList());
            }

            private Map<EntityType<?>, ResourceLocation> getDefaultEntityLootMapping() {
                LinkedHashMap mapping = new LinkedHashMap();
                mapping.put(EntityType.f_20558_, BuiltInLootTables.f_78764_);
                mapping.put(EntityType.f_20562_, BuiltInLootTables.f_78695_);
                mapping.put(EntityType.f_20566_, BuiltInLootTables.f_78741_);
                mapping.put(EntityType.f_20568_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20458_, BuiltInLootTables.f_78764_);
                mapping.put(EntityType.f_20511_, BuiltInLootTables.f_78699_);
                mapping.put(EntityType.f_20512_, BuiltInLootTables.f_78697_);
                mapping.put(EntityType.f_20513_, BuiltInLootTables.f_78696_);
                mapping.put(EntityType.f_20524_, BuiltInLootTables.f_78742_);
                mapping.put(EntityType.f_20481_, BuiltInLootTables.f_78688_);
                mapping.put(EntityType.f_20491_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20493_, BuiltInLootTables.f_78689_);
                mapping.put(EntityType.f_20495_, BuiltInLootTables.f_78692_);
                mapping.put(EntityType.f_20497_, BuiltInLootTables.f_78760_);
                mapping.put(EntityType.f_20501_, BuiltInLootTables.f_78742_);
                mapping.put(EntityType.f_20530_, BuiltInLootTables.f_78745_);
                mapping.put(EntityType.f_20531_, BuiltInLootTables.f_78698_);
                return mapping;
            }
        }

        public static class FilteredUpgradeConfigBase {
            public final ForgeConfigSpec.IntValue filterSlots;
            public final ForgeConfigSpec.IntValue slotsInRow;

            protected FilteredUpgradeConfigBase(ForgeConfigSpec.Builder builder, String name, String path, int defaultFilterSlots, int defaultSlotsInRow) {
                builder.comment(name + Config.SETTINGS).push(path);
                this.filterSlots = builder.comment("Number of " + name + "'s filter slots").defineInRange("filterSlots", defaultFilterSlots, 1, 20);
                this.slotsInRow = builder.comment("Number of filter slots displayed in a row").defineInRange("slotsInRow", defaultSlotsInRow, 1, 6);
            }
        }

        public static class SmeltingUpgradeConfigBase {
            public final ForgeConfigSpec.DoubleValue smeltingSpeedMultiplier;
            public final ForgeConfigSpec.DoubleValue fuelEfficiencyMultiplier;

            protected SmeltingUpgradeConfigBase(ForgeConfigSpec.Builder builder, String upgradeName, String path) {
                builder.comment(upgradeName + Config.SETTINGS).push(path);
                this.smeltingSpeedMultiplier = builder.comment("Smelting speed multiplier (1.0 equals speed at which vanilla furnace smelts items)").defineInRange("smeltingSpeedMultiplier", 1.0, 0.25, 4.0);
                this.fuelEfficiencyMultiplier = builder.comment("Fuel efficiency multiplier (1.0 equals speed at which it's used in vanilla furnace)").defineInRange("fuelEfficiencyMultiplier", 1.0, 0.25, 4.0);
            }
        }
    }
}

