/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import org.apache.logging.log4j.util.TriConsumer;

public class BackpackSettingsManager {
    private static final String SOPHISTICATED_BACKPACK_SETTINGS_TAG = "sophisticatedBackpackSettings";
    private static final Map<String, BackpackSetting<?>> settings = new HashMap();
    public static final BackpackSetting<Boolean> SHIFT_CLICK_INTO_OPEN_TAB_FIRST = new BackpackSetting<Boolean>("shiftClickOpenTab", NBTHelper::getBoolean, CompoundTag::m_128379_, true);
    public static final BackpackSetting<Boolean> KEEP_TAB_OPEN = new BackpackSetting<Boolean>("keepTabOpen", NBTHelper::getBoolean, CompoundTag::m_128379_, true);

    private BackpackSettingsManager() {
    }

    public static Optional<BackpackSetting<?>> getBackpackSetting(String settingName) {
        return Optional.ofNullable(settings.get(settingName));
    }

    public static <T> T getPlayerSettingOrDefault(Player player, BackpackSetting<T> setting) {
        return BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue());
    }

    public static <T> Optional<T> getPlayerSetting(Player player, BackpackSetting<T> setting) {
        return setting.getValue(BackpackSettingsManager.getPlayerBackpackSettingsTag(player));
    }

    public static CompoundTag getPlayerBackpackSettingsTag(Player player) {
        return player.getPersistentData().m_128469_(SOPHISTICATED_BACKPACK_SETTINGS_TAG);
    }

    public static void setPlayerBackpackSettingsTag(Player player, CompoundTag settingsNbt) {
        player.getPersistentData().m_128365_(SOPHISTICATED_BACKPACK_SETTINGS_TAG, (Tag)settingsNbt);
    }

    public static <T> void setPlayerSetting(Player player, BackpackSetting<T> setting, T value) {
        if (!player.getPersistentData().m_128441_(SOPHISTICATED_BACKPACK_SETTINGS_TAG)) {
            player.getPersistentData().m_128365_(SOPHISTICATED_BACKPACK_SETTINGS_TAG, (Tag)new CompoundTag());
        }
        if (value != setting.defaultValue) {
            setting.setValue(BackpackSettingsManager.getPlayerBackpackSettingsTag(player), value);
        } else {
            setting.removeFrom(BackpackSettingsManager.getPlayerBackpackSettingsTag(player));
        }
    }

    public static <T> void setBackpackSetting(Player player, BackpackSettingsCategory category, BackpackSetting<T> setting, T value) {
        T playerSettingValue = BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue());
        if (playerSettingValue != value) {
            category.setSettingValue(setting, value);
        } else {
            category.removeSetting(setting);
        }
    }

    public static <T> T getBackpackSettingValue(Player player, BackpackSettingsCategory category, BackpackSetting<T> setting) {
        return category.getSettingValue(setting).orElse(BackpackSettingsManager.getPlayerSetting(player, setting).orElse(setting.getDefaultValue()));
    }

    static {
        settings.put(SHIFT_CLICK_INTO_OPEN_TAB_FIRST.getName(), SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
        settings.put(KEEP_TAB_OPEN.getName(), KEEP_TAB_OPEN);
    }

    public static class BackpackSetting<T> {
        private final String tagName;
        private final BiFunction<CompoundTag, String, Optional<T>> getValue;
        private final TriConsumer<CompoundTag, String, T> setValue;
        private final T defaultValue;

        public BackpackSetting(String tagName, BiFunction<CompoundTag, String, Optional<T>> getValue, TriConsumer<CompoundTag, String, T> setValue, T defaultValue) {
            this.tagName = tagName;
            this.getValue = getValue;
            this.setValue = setValue;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.tagName;
        }

        public void setValue(CompoundTag tag, T value) {
            this.setValue.accept((Object)tag, (Object)this.tagName, value);
        }

        public void removeFrom(CompoundTag tag) {
            tag.m_128473_(this.tagName);
        }

        public Optional<T> getValue(CompoundTag tag) {
            return this.getValue.apply(tag, this.tagName);
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }
    }
}

