/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class BackpackRenderInfo {
    private static final String RENDER_INFO_TAG = "renderInfo";
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private final ItemStack backpack;
    private final Supplier<Runnable> getBackpackSaveHandler;
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;

    public BackpackRenderInfo(ItemStack backpack, Supplier<Runnable> getBackpackSaveHandler) {
        this.backpack = backpack;
        this.getBackpackSaveHandler = getBackpackSaveHandler;
        this.deserialize();
    }

    private void deserialize() {
        this.deserializeTanks();
        this.deserializeBattery();
    }

    private void save() {
        this.getBackpackSaveHandler.get().run();
    }

    public void deserializeFrom(CompoundTag renderInfoNbt) {
        this.reset();
        this.backpack.m_41700_(RENDER_INFO_TAG, (Tag)renderInfoNbt);
        this.deserialize();
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag();
    }

    public void reset() {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        NBTHelper.removeTag(this.backpack, RENDER_INFO_TAG);
        this.save();
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks() {
        CompoundTag renderInfo = this.getRenderInfoTag();
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.m_128461_(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.m_128469_(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery() {
        this.batteryRenderInfo = NBTHelper.getCompound(this.getRenderInfoTag(), BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag();
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            if (!tank.m_128461_(TANK_POSITION_TAG).equals(tankPosition.m_7912_())) continue;
            tank.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.m_128359_(TANK_POSITION_TAG, tankPosition.m_7912_());
            tankPositionInfo.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.m_128365_(TANKS_TAG, (Tag)tanks);
        }
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag();
        renderInfo.m_128365_(BATTERY_TAG, (Tag)batteryInfo);
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
        this.save();
    }

    @Nonnull
    private CompoundTag getRenderInfoTag() {
        return NBTHelper.getCompound(this.backpack, RENDER_INFO_TAG).orElse(new CompoundTag());
    }
}

