/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsCategory;

public class BackpackSettingsHandler {
    public static final String SETTINGS_TAG = "settings";
    private final CompoundTag backpackContentsNbt;
    private final Runnable markBackpackContentsDirty;
    private final Map<Class<?>, List<?>> interfaceCategories = new HashMap();
    private final Map<String, ISettingsCategory> settingsCategories = new LinkedHashMap<String, ISettingsCategory>();
    private final Map<Class<? extends ISettingsCategory>, ISettingsCategory> typeCategories = new HashMap<Class<? extends ISettingsCategory>, ISettingsCategory>();

    public BackpackSettingsHandler(CompoundTag backpackContentsNbt, Runnable markBackpackContentsDirty) {
        this.backpackContentsNbt = backpackContentsNbt;
        this.markBackpackContentsDirty = markBackpackContentsDirty;
        this.addSettingsCategories(backpackContentsNbt.m_128469_(SETTINGS_TAG));
    }

    private void addSettingsCategories(CompoundTag settingsNbt) {
        this.addSettingsCategory(settingsNbt, "backpack", this.markBackpackContentsDirty, BackpackSettingsCategory::new);
        this.addSettingsCategory(settingsNbt, "no_sort", this.markBackpackContentsDirty, NoSortSettingsCategory::new);
    }

    private void addSettingsCategory(CompoundTag settingsNbt, String categoryName, Runnable markBackpackContentsDirty, BiFunction<CompoundTag, Consumer<CompoundTag>, ISettingsCategory> instantiateCategory) {
        ISettingsCategory category = instantiateCategory.apply(settingsNbt.m_128469_(categoryName), tag -> {
            settingsNbt.m_128365_(categoryName, (Tag)tag);
            this.backpackContentsNbt.m_128365_(SETTINGS_TAG, (Tag)settingsNbt);
            markBackpackContentsDirty.run();
        });
        this.settingsCategories.put(categoryName, category);
        this.typeCategories.put(category.getClass(), category);
    }

    public Map<String, ISettingsCategory> getSettingsCategories() {
        return this.settingsCategories;
    }

    public <T> List<T> getCategoriesThatImplement(Class<T> categoryClass) {
        return this.interfaceCategories.computeIfAbsent(categoryClass, this::getListOfWrappersThatImplement);
    }

    public <T extends ISettingsCategory> T getTypeCategory(Class<T> categoryClazz) {
        return (T)this.typeCategories.get(categoryClazz);
    }

    private <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<ISettingsCategory> ret = new ArrayList<ISettingsCategory>();
        for (ISettingsCategory category : this.settingsCategories.values()) {
            if (!uc.isInstance(category)) continue;
            ret.add(category);
        }
        return ret;
    }

    public void copyTo(BackpackSettingsHandler settingsHandler) {
        if (this.backpackContentsNbt.m_128441_(SETTINGS_TAG)) {
            settingsHandler.backpackContentsNbt.m_128365_(SETTINGS_TAG, this.backpackContentsNbt.m_128423_(SETTINGS_TAG));
        }
    }

    public CompoundTag getNbt() {
        return this.backpackContentsNbt.m_128469_(SETTINGS_TAG);
    }

    public void reloadFrom(CompoundTag backpackContentsNbt) {
        CompoundTag settingsNbt = backpackContentsNbt.m_128469_(SETTINGS_TAG);
        this.settingsCategories.forEach((categoryName, category) -> category.reloadFrom(settingsNbt.m_128469_(categoryName)));
    }
}

