/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInsertResponseUpgrade;

public class InsertResponseInventoryWrapper
implements IItemHandlerModifiable {
    private final IBackpackWrapper backpackWrapper;
    private final IItemHandlerModifiable inventory;

    public InsertResponseInventoryWrapper(IBackpackWrapper backpackWrapper, IItemHandlerModifiable inventory) {
        this.backpackWrapper = backpackWrapper;
        this.inventory = inventory;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack ret = this.runOnBeforeInsert(slot, stack, simulate, (IItemHandler)this, this.backpackWrapper);
        if (ret.m_41619_()) {
            return ret;
        }
        if ((ret = this.inventory.insertItem(slot, ret, simulate)) == stack) {
            return ret;
        }
        this.runOnAfterInsert(slot, simulate, (IItemHandler)this, this.backpackWrapper);
        return ret;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inventory.isItemValid(slot, stack);
    }

    private void runOnAfterInsert(int slot, boolean simulate, IItemHandler handler, IBackpackWrapper backpackWrapper) {
        if (!simulate) {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplementFromMainBackpack(IInsertResponseUpgrade.class).forEach(u -> u.onAfterInsert(handler, slot));
        }
    }

    private ItemStack runOnBeforeInsert(int slot, ItemStack stack, boolean simulate, IItemHandler handler, IBackpackWrapper backpackWrapper) {
        List<IInsertResponseUpgrade> wrappers = backpackWrapper.getUpgradeHandler().getWrappersThatImplementFromMainBackpack(IInsertResponseUpgrade.class);
        ItemStack remaining = stack;
        for (IInsertResponseUpgrade upgrade : wrappers) {
            remaining = upgrade.onBeforeInsert(handler, slot, remaining, simulate);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }
}

