/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockEntityRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackDynamicModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackTooltipRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.BackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class ClientEventHandler {
    private static final String BACKPACK_REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("sophisticatedbackpacks", "backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::loadComplete);
        modBus.addListener(ClientEventHandler::clientSetup);
        modBus.addListener(ClientEventHandler::stitchTextures);
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerReloadListener);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(BackpackTooltipRenderer::renderBackpackTooltip);
        eventBus.addListener(BackpackTooltipRenderer::onWorldLoad);
        eventBus.addListener(BackpackSoundHandler::tick);
        eventBus.addListener(BackpackSoundHandler::onWorldUnload);
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
        });
    }

    private static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)RegistryHelper.getRL(BACKPACK_REG_NAME), (IModelLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.IRON_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GOLD_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DIAMOND_BACKPACK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.NETHERITE_BACKPACK.get()), (RenderType)RenderType.m_110463_());
    }

    public static void registerReloadListener(ParticleFactoryRegisterEvent event) {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> ClientEventHandler.registerBackpackLayer()));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), BackpackBlockEntityRenderer::new);
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            EntityRenderer entityRenderer = renderer;
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
        }
        renderManager.f_114362_.forEach((e, r) -> {
            EntityRenderer livingEntityRenderer$temp = r;
            if (livingEntityRenderer$temp instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)livingEntityRenderer$temp;
                livingEntityRenderer.m_115326_(new BackpackLayerRenderer(livingEntityRenderer));
            }
        });
    }

    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().m_118330_() == InventoryMenu.f_39692_) {
            evt.addSprite(BackpackContainer.EMPTY_UPGRADE_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_INPUT_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_OUTPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_INPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND);
        }
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        RecipeHelper.setWorld((Level)Minecraft.m_91087_().f_91073_);
    }
}

