/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;

public class Button
extends ButtonBase {
    private final TextureBlitData backgroundTexture;
    @Nullable
    private final TextureBlitData hoveredBackgroundTexture;
    @Nullable
    private final TextureBlitData foregroundTexture;
    private final List<FormattedText> tooltip;

    public Button(Position position, ButtonDefinition buttonDefinition, IntConsumer onClick) {
        super(position, buttonDefinition.getDimension(), onClick);
        this.backgroundTexture = buttonDefinition.getBackgroundTexture();
        this.foregroundTexture = buttonDefinition.getForegroundTexture();
        this.hoveredBackgroundTexture = buttonDefinition.getHoveredBackgroundTexture();
        this.tooltip = Collections.singletonList(buttonDefinition.getTooltip());
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.hoveredBackgroundTexture != null) {
                GuiHelper.blit(minecraft, matrixStack, this.x, this.y, this.hoveredBackgroundTexture);
            }
        } else {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, this.backgroundTexture);
        }
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.foregroundTexture != null) {
            GuiHelper.blit(this.minecraft, matrixStack, this.x, this.y, this.foregroundTexture);
        }
        if (this.m_5953_(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(this.tooltip);
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)new TranslatableComponent("gui.narrate.button", new Object[]{this.tooltip}));
        pNarrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.button.usage.focused"));
    }
}

