/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = new ResourceLocation("sophisticatedbackpacks", "textures/gui/gui_controls.png");
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = new ResourceLocation("sophisticatedbackpacks", "textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = new ResourceLocation("sophisticatedbackpacks", "textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();
    private static List<? extends FormattedText> tooltipToRender = Collections.emptyList();

    private GuiHelper() {
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(Minecraft minecraft, PoseStack matrixStack, int x, int y, int slotWidth, int slotHeight) {
        int key = GuiHelper.getSlotsBackgroundKey(slotWidth, slotHeight);
        GuiHelper.blit(minecraft, matrixStack, x, y, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, slotHeight * 18))));
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        ItemRenderer itemRenderer = minecraft.m_91291_();
        float originalZLevel = itemRenderer.f_115093_;
        itemRenderer.f_115093_ += (float)GuiHelper.getZOffset(matrixStack);
        itemRenderer.m_115203_(stack, xPosition, yPosition);
        if (renderOverlay) {
            itemRenderer.m_115174_(minecraft.f_91062_, stack, xPosition, yPosition, countText);
        }
        itemRenderer.f_115093_ = originalZLevel;
    }

    private static int getZOffset(PoseStack matrixStack) {
        Float zOffset = (Float)ObfuscationReflectionHelper.getPrivateValue(Matrix4f.class, (Object)matrixStack.m_85850_().m_85861_(), (String)"f_27614_");
        return zOffset == null ? 0 : zOffset.intValue();
    }

    public static void blit(Minecraft minecraft, PoseStack matrixStack, int x, int y, TextureBlitData texData) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texData.getTextureName());
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset()), (float)texData.getU(), (float)texData.getV(), (int)texData.getWidth(), (int)texData.getHeight(), (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(matrix, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void setTooltipToRender(List<? extends FormattedText> tooltip) {
        tooltipToRender = tooltip;
    }

    public static void renderTooltip(Minecraft minecraft, PoseStack matrixStack, int mouseX, int mouseY) {
        if (tooltipToRender.isEmpty()) {
            return;
        }
        GuiHelper.renderTooltip(minecraft, matrixStack, tooltipToRender, mouseX, mouseY, ITooltipRenderPart.EMPTY, null, ItemStack.f_41583_, 150);
        tooltipToRender = Collections.emptyList();
    }

    public static void renderTooltip(Minecraft minecraft, PoseStack matrixStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, ITooltipRenderPart additionalRender, @Nullable Font tooltipRenderFont, ItemStack stack) {
        GuiHelper.renderTooltip(minecraft, matrixStack, textLines, mouseX, mouseY, additionalRender, tooltipRenderFont, stack, 0);
    }

    public static void renderTooltip(Minecraft minecraft, PoseStack matrixStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, ITooltipRenderPart additionalRender, @Nullable Font tooltipRenderFont, ItemStack stack, int maxTextWidth) {
        int leftX;
        Font font = tooltipRenderFont == null ? minecraft.f_91062_ : tooltipRenderFont;
        int windowWidth = minecraft.m_91268_().m_85445_();
        int windowHeight = minecraft.m_91268_().m_85446_();
        int tooltipWidth = GuiHelper.getMaxLineWidth(textLines, font);
        tooltipWidth = Math.max(tooltipWidth, additionalRender.getWidth());
        boolean needsWrap = false;
        if (maxTextWidth > 0 && tooltipWidth > maxTextWidth) {
            tooltipWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (FormattedText formattedText : textLines) {
                List wrappedLine = font.m_92865_().m_92414_(formattedText, tooltipWidth, Style.f_131099_);
                for (FormattedText line : wrappedLine) {
                    int lineWidth = font.m_92852_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((FormattedText)line);
                }
            }
            tooltipWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
        }
        if ((leftX = mouseX + 12) + tooltipWidth > windowWidth) {
            leftX -= 28 + tooltipWidth;
        }
        int topY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += 2 + (textLines.size() - 1) * 10;
        }
        if (topY + (tooltipHeight += additionalRender.getHeight()) + 6 > windowHeight) {
            topY = windowHeight - tooltipHeight - 6;
        }
        int n = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, matrixStack, leftX, topY, font, n, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        int n2 = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        matrixStack.m_85836_();
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, leftX, topY, tooltipHeight, n2, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, matrixStack, leftX, topY, font, tooltipWidth, tooltipHeight));
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85837_(0.0, 0.0, 400.0);
        topY = GuiHelper.writeTooltipLines(textLines, font, leftX, topY, matrix4f, renderTypeBuffer, -1);
        renderTypeBuffer.m_109911_();
        additionalRender.render(matrixStack, leftX, topY, font);
        matrixStack.m_85849_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, matrixStack, leftX, topY, font, tooltipWidth, tooltipHeight));
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, 400, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, 400, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, 400, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, 400, borderColorEnd, borderColorEnd);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private static int getMaxLineWidth(List<? extends FormattedText> tooltips, Font font) {
        int maxLineWidth = 0;
        for (FormattedText formattedText : tooltips) {
            int lineWidth = font.m_92852_(formattedText);
            if (lineWidth <= maxLineWidth) continue;
            maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }

    public static int writeTooltipLines(List<? extends FormattedText> textLines, Font font, float leftX, int topY, Matrix4f matrix4f, MultiBufferSource.BufferSource renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedText line = textLines.get(i);
            if (line != null) {
                font.m_92733_(Language.m_128107_().m_5536_(line), leftX, (float)topY, color, true, matrix4f, (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
        return topY;
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{new TranslatableComponent(tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<? extends Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(Minecraft minecraft, PoseStack matrixStack, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(minecraft, matrixStack, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static interface ITooltipRenderPart {
        public static final ITooltipRenderPart EMPTY = new ITooltipRenderPart(){

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 0;
            }

            @Override
            public void render(PoseStack matrixStack, int leftX, int topY, Font font) {
            }
        };

        public int getWidth();

        public int getHeight();

        public void render(PoseStack var1, int var2, int var3, Font var4);
    }
}

