/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TranslationHelper {
    private static final String TOOLTIP_SUFFIX = ".tooltip";
    private static final String GUI_PREFIX = "gui.sophisticatedbackpacks.";
    private static final String GUI_UPGRADE_PREFIX = "gui.sophisticatedbackpacks.upgrades.";
    private static final String GUI_SETTINGS_PREFIX = "gui.sophisticatedbackpacks.settings.";
    private static final String BUTTONS_SUFFIX = "buttons.";
    private static final String BUTTONS_PREFIX = "gui.sophisticatedbackpacks.buttons.";
    private static final String ITEM_UPGRADE_PREFIX = "item.sophisticatedbackpacks.";
    private static final String UPGRADE_BUTTONS_PREFIX = "gui.sophisticatedbackpacks.upgrades.buttons.";
    private static final String KEYBIND_PREFIX = "keybind.sophisticatedbackpacks.";

    private TranslationHelper() {
    }

    public static Component translUpgrade(String upgradeName) {
        return new TranslatableComponent(TranslationHelper.translUpgradeKey(upgradeName));
    }

    public static Component translUpgradeSlotTooltip(String tooltipName) {
        return new TranslatableComponent("gui.sophisticatedbackpacks.upgrades.slots." + tooltipName + TOOLTIP_SUFFIX);
    }

    public static String translUpgradeKey(String upgradeName) {
        return GUI_UPGRADE_PREFIX + upgradeName;
    }

    public static String translSettings(String categoryName) {
        return GUI_SETTINGS_PREFIX + categoryName;
    }

    public static String translSettingsButton(String buttonName) {
        return TranslationHelper.translSettings(BUTTONS_SUFFIX + buttonName);
    }

    public static Component translUpgradeTooltip(String upgradeName) {
        return new TranslatableComponent(TranslationHelper.translUpgradeKey(upgradeName) + TOOLTIP_SUFFIX);
    }

    public static String translSettingsTooltip(String categoryName) {
        return TranslationHelper.translSettings(categoryName) + TOOLTIP_SUFFIX;
    }

    public static Component translColoredButton(String buttonName, ChatFormatting color) {
        return new TranslatableComponent(TranslationHelper.translButton(buttonName)).m_130940_(color);
    }

    public static String translButton(String buttonName) {
        return BUTTONS_PREFIX + buttonName;
    }

    public static Component translError(String key, Object ... params) {
        return new TranslatableComponent("gui.sophisticatedbackpacks.error." + key, params);
    }

    public static String translUpgradeButton(String buttonName) {
        return UPGRADE_BUTTONS_PREFIX + buttonName;
    }

    public static String translItemTooltip(String itemName) {
        return ITEM_UPGRADE_PREFIX + itemName + TOOLTIP_SUFFIX;
    }

    public static List<TextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters, ChatFormatting ... textFormattings) {
        List<TextComponent> ret = TranslationHelper.getTranslatedLines(translateKey, parameters);
        ret.forEach(l -> l.m_130944_(textFormattings));
        return ret;
    }

    public static List<TextComponent> getTranslatedLines(String translateKey) {
        return TranslationHelper.getTranslatedLines(translateKey, null);
    }

    public static List<TextComponent> getTranslatedLines(String translateKey, @Nullable Object parameters) {
        String text = TranslationHelper.translate(translateKey, parameters);
        String[] lines = text.split("\n");
        ArrayList<TextComponent> ret = new ArrayList<TextComponent>();
        for (String line : lines) {
            ret.add(new TextComponent(line));
        }
        return ret;
    }

    public static String translate(String translateKey, Object ... parameters) {
        return I18n.m_118938_((String)translateKey, (Object[])parameters);
    }

    public static String translKeybind(String keybindName) {
        return KEYBIND_PREFIX + keybindName;
    }

    public static String translGui(String guiTranslateKey) {
        return GUI_PREFIX + guiTranslateKey;
    }
}

