/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;

public class BackpackBlockEntityRenderer
implements BlockEntityRenderer<BackpackBlockEntity> {
    private final BackpackModel model;

    public BackpackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new BackpackModel(context.m_173582_(ClientEventHandler.BACKPACK_LAYER));
    }

    public void render(BackpackBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        BlockState state = tileEntityIn.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)BackpackBlock.FACING);
        boolean showLeftTank = (Boolean)state.m_61143_((Property)BackpackBlock.LEFT_TANK);
        boolean showRightTank = (Boolean)state.m_61143_((Property)BackpackBlock.RIGHT_TANK);
        boolean showBattery = (Boolean)state.m_61143_((Property)BackpackBlock.BATTERY);
        BackpackRenderInfo renderInfo = tileEntityIn.getBackpackWrapper().getRenderInfo();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(facing.m_122435_()));
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        matrixStack.m_85837_(0.0, -1.69, 0.0);
        if (showLeftTank && (tankRenderInfo = renderInfo.getTankRenderInfos().get((Object)TankPosition.LEFT)) != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.15, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> this.model.renderFluid(matrixStack, buffer, combinedLight, (Fluid)fluid, tankRenderInfo.getFillRatio(), true));
            matrixStack.m_85849_();
        }
        if (showRightTank && (tankRenderInfo = renderInfo.getTankRenderInfos().get((Object)TankPosition.RIGHT)) != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(-0.15, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> this.model.renderFluid(matrixStack, buffer, combinedLight, (Fluid)fluid, tankRenderInfo.getFillRatio(), false));
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        if (showBattery) {
            renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                if (batteryRenderInfo.getChargeRatio() > 0.1f) {
                    matrixStack.m_85836_();
                    matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(180.0f));
                    matrixStack.m_85837_(0.0, -1.5, 0.0);
                    this.model.renderBatteryCharge(matrixStack, buffer, combinedLight, batteryRenderInfo.getChargeRatio());
                    matrixStack.m_85849_();
                }
            });
        }
        matrixStack.m_85849_();
    }
}

