/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackLayerRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final float CHILD_Y_OFFSET = 0.3f;
    private static final float CHILD_Z_OFFSET = 0.1f;
    private static final float CHILD_SCALE = 0.55f;
    private static final Map<EntityType<?>, Vec3> entityTranslations = new HashMap();
    private final BackpackModel model;

    public BackpackLayerRenderer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
        EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
        this.model = new BackpackModel(entityModels.m_171103_(ClientEventHandler.BACKPACK_LAYER));
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        T t = entity;
        if (t instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)t;
            PlayerInventoryProvider.get().getBackpackFromRendered((Player)player).ifPresent(backpackRenderInfo -> {
                matrixStack.m_85836_();
                boolean wearsArmor = !backpackRenderInfo.isArmorSlot() && !((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                BackpackLayerRenderer.renderBackpack((LivingEntity)player, matrixStack, buffer, packedLight, backpack, wearsArmor, this.model);
                matrixStack.m_85849_();
            });
        } else {
            ItemStack chestStack = entity.m_6844_(EquipmentSlot.CHEST);
            if (chestStack.m_41720_() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(entity, matrixStack, buffer, packedLight, chestStack, false, this.model);
            }
        }
    }

    public static void renderBackpack(LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, ItemStack backpack, boolean wearsArmor, BackpackModel model) {
        if (livingEntity.m_6047_()) {
            matrixStack.m_85837_(0.0, 0.2, 0.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(28.647888f));
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (livingEntity.m_6162_()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.m_85837_(0.0, (double)yOffset, (double)zOffset);
        if (livingEntity.m_6162_()) {
            matrixStack.m_85841_(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.m_6095_())) {
            Vec3 translVector = entityTranslations.get(livingEntity.m_6095_());
            matrixStack.m_85837_(translVector.m_7096_(), translVector.m_7098_(), translVector.m_7094_());
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            int clothColor = wrapper.getClothColor();
            int borderColor = wrapper.getBorderColor();
            model.render(matrixStack, buffer, packedLight, clothColor, borderColor, backpack.m_41720_(), wrapper.getRenderInfo());
        });
    }

    static {
        entityTranslations.put(EntityType.f_20566_, new Vec3(0.0, -0.8, 0.0));
    }
}

