/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestBackpackInventoryContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class BackpackTooltipRenderer {
    private static final String BACKPACK_ITEM_NAME = "backpack";
    private static final int REFRESH_INTERVAL = 20;
    private static boolean shouldRefreshContents = true;
    private static long lastRequestTime = 0L;
    private static ContentsTooltipPart contentsTooltipPart;
    @Nullable
    private static UUID backpackUuid;

    private BackpackTooltipRenderer() {
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        shouldRefreshContents = true;
        lastRequestTime = 0L;
    }

    public static void renderBackpackTooltip(RenderTooltipEvent.Pre event) {
        ItemStack backpack = event.getStack();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (!(backpack.m_41720_() instanceof BackpackItem) || !Screen.m_96638_() || player == null) {
            return;
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            UUID newUuid = wrapper.getContentsUuid().orElse(null);
            if (backpackUuid == null && newUuid != null || backpackUuid != null && !backpackUuid.equals(newUuid)) {
                lastRequestTime = 0L;
                backpackUuid = newUuid;
                shouldRefreshContents = true;
            }
            BackpackTooltipRenderer.requestContents(player, wrapper);
            BackpackTooltipRenderer.refreshContents(wrapper, minecraft);
            List lines = backpack.m_41651_((Player)player, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            if (backpackUuid != null) {
                int multiplier = wrapper.getInventoryHandler().getStackSizeMultiplier();
                if (multiplier > 1) {
                    lines.add(new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.stack_multiplier", new Object[]{new TextComponent(Integer.toString(multiplier)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
                }
                BackpackTooltipRenderer.addEnergytooltip(wrapper, lines);
                BackpackTooltipRenderer.addFluidTooltip(wrapper, lines);
            }
            GuiHelper.renderTooltip(minecraft, event.getMatrixStack(), lines, event.getX(), event.getY(), contentsTooltipPart, event.getFontRenderer(), backpack);
            event.setCanceled(true);
        });
    }

    private static void addEnergytooltip(IBackpackWrapper wrapper, List<Component> lines) {
        wrapper.getEnergyStorage().ifPresent(energyStorage -> lines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".energy", new Object[]{new TextComponent(CountAbbreviator.abbreviate(energyStorage.getEnergyStored())).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED)));
    }

    private static void addFluidTooltip(IBackpackWrapper wrapper, List<Component> lines) {
        wrapper.getFluidHandler().ifPresent(fluidHandler -> {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluid = fluidHandler.getFluidInTank(tank);
                if (fluid.isEmpty()) {
                    lines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid_empty").m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                lines.add((Component)new TranslatableComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid", new Object[]{new TextComponent(CountAbbreviator.abbreviate(fluid.getAmount())).m_130940_(ChatFormatting.WHITE), new TranslatableComponent(fluid.getTranslationKey()).m_130940_(ChatFormatting.BLUE)}));
            }
        });
    }

    private static void requestContents(LocalPlayer player, IBackpackWrapper wrapper) {
        if (lastRequestTime + 20L < player.f_19853_.m_46467_()) {
            lastRequestTime = player.f_19853_.m_46467_();
            wrapper.getContentsUuid().ifPresent(uuid -> PacketHandler.sendToServer(new RequestBackpackInventoryContentsMessage((UUID)uuid)));
        }
    }

    private static void refreshContents(IBackpackWrapper wrapper, Minecraft minecraft) {
        if (shouldRefreshContents) {
            shouldRefreshContents = false;
            if (backpackUuid != null) {
                wrapper.onContentsNbtUpdated();
                List<ItemStack> sortedContents = InventoryHelper.getCompactedStacksSortedByCount((IItemHandler)wrapper.getInventoryHandler());
                contentsTooltipPart = new ContentsTooltipPart(minecraft, new TreeMap<Integer, IUpgradeWrapper>(wrapper.getUpgradeHandler().getSlotWrappers()), sortedContents);
            } else {
                contentsTooltipPart = BackpackTooltipRenderer.getEmptyInventoryTooltip(minecraft);
            }
        }
        if (contentsTooltipPart == null) {
            contentsTooltipPart = BackpackTooltipRenderer.getEmptyInventoryTooltip(minecraft);
        }
    }

    private static ContentsTooltipPart getEmptyInventoryTooltip(Minecraft minecraft) {
        return new ContentsTooltipPart(minecraft, new HashMap<Integer, IUpgradeWrapper>(), new ArrayList<ItemStack>());
    }

    public static void refreshContents() {
        shouldRefreshContents = true;
    }

    static {
        backpackUuid = null;
    }

    private static class ContentsTooltipPart
    implements GuiHelper.ITooltipRenderPart {
        private static final TextureBlitData UPGRADE_ON = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(81, 0), Dimension.RECTANGLE_4_10);
        private static final TextureBlitData UPGRADE_OFF = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(77, 0), Dimension.RECTANGLE_4_10);
        private static final int MAX_STACKS_ON_LINE = 9;
        private static final int DEFAULT_STACK_WIDTH = 18;
        private static final int COUNT_PADDING = 2;
        private final Minecraft minecraft;
        private final Map<Integer, IUpgradeWrapper> upgrades;
        private final List<ItemStack> backpackContents;
        private int height;
        private int width;

        public ContentsTooltipPart(Minecraft minecraft, Map<Integer, IUpgradeWrapper> upgrades, List<ItemStack> backpackContents) {
            this.minecraft = minecraft;
            this.upgrades = upgrades;
            this.backpackContents = backpackContents;
            this.calculateHeight();
            this.calculateWidth();
        }

        private void calculateWidth() {
            int contentsWidth;
            int upgradesWidth = this.calculateUpgradesWidth();
            int stacksWidth = Math.max(upgradesWidth, contentsWidth = this.calculateContentsWidth());
            this.width = stacksWidth > 0 ? stacksWidth : this.getEmptyTooltipWidth();
        }

        private int calculateUpgradesWidth() {
            int upgradesWidth = 0;
            for (IUpgradeWrapper upgradeWrapper : this.upgrades.values()) {
                upgradesWidth += (upgradeWrapper.canBeDisabled() ? 4 : 0) + 18;
            }
            return upgradesWidth;
        }

        private int calculateContentsWidth() {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int contentsWidth = 0;
            for (int i = 0; i < this.backpackContents.size() && i < 9; ++i) {
                int countWidth = this.getStackCountWidth(fontRenderer, this.backpackContents.get(i));
                contentsWidth += Math.max(countWidth, 18);
            }
            return contentsWidth;
        }

        private int getStackCountWidth(Font fontRenderer, ItemStack stack) {
            return fontRenderer.m_92895_(CountAbbreviator.abbreviate(stack.m_41613_())) + 2;
        }

        private void calculateHeight() {
            int upgradesHeight = this.upgrades.isEmpty() ? 0 : 32;
            int inventoryHeight = this.backpackContents.isEmpty() ? 0 : 12 + (1 + this.backpackContents.size() / 9) * 20;
            int totalHeight = upgradesHeight + inventoryHeight;
            this.height = totalHeight > 0 ? totalHeight : 12;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        private int getEmptyTooltipWidth() {
            return Minecraft.m_91087_().f_91062_.m_92724_(new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip.empty").m_7532_());
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(PoseStack matrixStack, int leftX, int topY, Font font) {
            if (!this.upgrades.isEmpty()) {
                topY = this.renderTooltipLine(leftX, topY, matrixStack, font, "upgrades");
                topY = this.renderUpgrades(matrixStack, leftX, topY);
            }
            if (!this.backpackContents.isEmpty()) {
                topY = this.renderTooltipLine(leftX, topY, matrixStack, font, "inventory");
                this.renderContents(matrixStack, leftX, topY);
            }
            if (this.upgrades.isEmpty() && this.backpackContents.isEmpty()) {
                this.renderTooltipLine(leftX, topY, matrixStack, font, "empty");
            }
        }

        private int renderTooltipLine(int leftX, int topY, PoseStack matrixStack, Font font, String tooltip) {
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            topY = GuiHelper.writeTooltipLines(Collections.singletonList(new TranslatableComponent("item.sophisticatedbackpacks.backpack.tooltip." + tooltip).m_130940_(ChatFormatting.YELLOW)), font, leftX, topY, matrixStack.m_85850_().m_85861_(), renderTypeBuffer, -1);
            renderTypeBuffer.m_109911_();
            return topY;
        }

        private int renderUpgrades(PoseStack matrixStack, int leftX, int topY) {
            int x = leftX;
            for (IUpgradeWrapper upgradeWrapper : this.upgrades.values()) {
                if (upgradeWrapper.canBeDisabled()) {
                    GuiHelper.blit(this.minecraft, matrixStack, x, topY + 3, upgradeWrapper.isEnabled() ? UPGRADE_ON : UPGRADE_OFF);
                    x += 4;
                }
                GuiHelper.renderItemInGUI(matrixStack, this.minecraft, upgradeWrapper.getUpgradeStack(), x, topY, true);
                x += 18;
            }
            return topY += 20;
        }

        private void renderContents(PoseStack matrixStack, int leftX, int topY) {
            int x = leftX;
            for (int i = 0; i < this.backpackContents.size(); ++i) {
                int y = topY + i / 9 * 20;
                if (i % 9 == 0) {
                    x = leftX;
                }
                ItemStack stack = this.backpackContents.get(i);
                int stackWidth = Math.max(this.getStackCountWidth(this.minecraft.f_91062_, stack), 18);
                int xOffset = stackWidth - 18;
                GuiHelper.renderItemInGUI(matrixStack, this.minecraft, stack, x + xOffset, y, true, CountAbbreviator.abbreviate(stack.m_41613_()));
                x += stackWidth;
            }
        }
    }
}

