/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.ServerBackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;

public class CommonEventHandler {
    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(ServerBackpackSoundHandler::tick);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PacketHandler.sendToClient((ServerPlayer)event.getPlayer(), new SyncPlayerSettingsMessage(BackpackSettingsManager.getPlayerBackpackSettingsTag(event.getPlayer())));
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.sendToClient((ServerPlayer)event.getPlayer(), new SyncPlayerSettingsMessage(BackpackSettingsManager.getPlayerBackpackSettingsTag(event.getPlayer())));
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getPlayer();
        if (player.f_19853_.f_46443_) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Monster monster;
        Entity entity = event.getEntity();
        Entity entity2 = entity;
        if (entity2 instanceof Monster && (monster = (Monster)entity2).m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            EntityBackpackAdditionHandler.addBackpack(monster);
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            EntityBackpackAdditionHandler.removeBeneficialEffects(creeper);
        }
    }

    private void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((Monster)event.getEntity());
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        ItemStack remainingStackSimulated = itemEntity.m_32055_().m_41777_();
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryHelper.runPickupOnBackpack(world, remainingStackSimulated, wrapper, true)).orElse(false));
        if (remainingStackSimulated.m_41619_()) {
            ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryHelper.runPickupOnBackpack(world, remainingStack, wrapper, false)).orElse(false));
            if (!itemEntity.m_20067_()) {
                Random rand = itemEntity.f_19853_.f_46441_;
                itemEntity.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.m_32045_(ItemStack.f_41583_);
            event.setCanceled(true);
        }
    }
}

