/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WeightedElement;

public class EntityBackpackAdditionHandler {
    private static final int MAX_DIFFICULTY = 3;
    private static final String SPAWNED_WITH_BACKPACK = "spawnedWithBackpack";
    private static final String SPAWNED_WITH_JUKEBOX_UPGRADE = "sophisticatedbackpacks:jukebox";
    private static final List<WeightedElement<Item>> HELMET_CHANCES = List.of(new WeightedElement<Item>(1, Items.f_42480_), new WeightedElement<Item>(3, Items.f_42472_), new WeightedElement<Item>(9, Items.f_42476_), new WeightedElement<Item>(27, Items.f_42468_), new WeightedElement<Item>(81, Items.f_42407_));
    private static final List<WeightedElement<Item>> LEGGINGS_CHANCES = List.of(new WeightedElement<Item>(1, Items.f_42482_), new WeightedElement<Item>(3, Items.f_42474_), new WeightedElement<Item>(9, Items.f_42478_), new WeightedElement<Item>(27, Items.f_42470_), new WeightedElement<Item>(81, Items.f_42462_));
    private static final List<WeightedElement<Item>> BOOTS_CHANCES = List.of(new WeightedElement<Item>(1, Items.f_42483_), new WeightedElement<Item>(3, Items.f_42475_), new WeightedElement<Item>(9, Items.f_42479_), new WeightedElement<Item>(27, Items.f_42471_), new WeightedElement<Item>(81, Items.f_42463_));
    private static final List<WeightedElement<BackpackAddition>> BACKPACK_CHANCES = List.of(new WeightedElement<BackpackAddition>(1, new BackpackAddition((Item)ModItems.NETHERITE_BACKPACK.get(), 4, HELMET_CHANCES.subList(0, 1), LEGGINGS_CHANCES.subList(0, 1), BOOTS_CHANCES.subList(0, 1))), new WeightedElement<BackpackAddition>(5, new BackpackAddition((Item)ModItems.DIAMOND_BACKPACK.get(), 3, HELMET_CHANCES.subList(0, 2), LEGGINGS_CHANCES.subList(0, 2), BOOTS_CHANCES.subList(0, 2))), new WeightedElement<BackpackAddition>(25, new BackpackAddition((Item)ModItems.GOLD_BACKPACK.get(), 2, HELMET_CHANCES.subList(1, 3), LEGGINGS_CHANCES.subList(1, 3), BOOTS_CHANCES.subList(1, 3))), new WeightedElement<BackpackAddition>(125, new BackpackAddition((Item)ModItems.IRON_BACKPACK.get(), 1, HELMET_CHANCES.subList(2, 4), LEGGINGS_CHANCES.subList(2, 4), BOOTS_CHANCES.subList(2, 4))), new WeightedElement<BackpackAddition>(625, new BackpackAddition((Item)ModItems.BACKPACK.get(), 0, HELMET_CHANCES.subList(3, 5), LEGGINGS_CHANCES.subList(3, 5), BOOTS_CHANCES.subList(3, 5))));
    private static List<RecordItem> musicDiscs = null;
    private static final List<ApplicableEffect> APPLICABLE_EFFECTS = List.of(new ApplicableEffect(MobEffects.f_19606_, 3), new ApplicableEffect(MobEffects.f_19607_), new ApplicableEffect(MobEffects.f_19617_), new ApplicableEffect(MobEffects.f_19616_), new ApplicableEffect(MobEffects.f_19605_), new ApplicableEffect(MobEffects.f_19596_), new ApplicableEffect(MobEffects.f_19600_));

    private EntityBackpackAdditionHandler() {
    }

    static void addBackpack(Monster monster) {
        Random rnd = monster.f_19853_.f_46441_;
        if (!Config.COMMON.entityBackpackAdditions.canWearBackpack(monster.m_6095_()) || rnd.nextInt((int)(1.0 / (Double)Config.COMMON.entityBackpackAdditions.chance.get())) != 0) {
            return;
        }
        RandHelper.getRandomWeightedElement(rnd, BACKPACK_CHANCES).ifPresent(backpackAddition -> {
            ItemStack backpack = new ItemStack((ItemLike)backpackAddition.getBackpackItem());
            int minDifficulty = backpackAddition.getMinDifficulty();
            int difficulty = Math.max(minDifficulty, rnd.nextInt(4));
            EntityBackpackAdditionHandler.equipBackpack(monster, backpack, difficulty, Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.playJukebox.get()) && rnd.nextInt(4) == 0);
            EntityBackpackAdditionHandler.applyPotions(monster, difficulty, minDifficulty);
            EntityBackpackAdditionHandler.raiseHealth(monster, minDifficulty);
            if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.equipWithArmor.get())) {
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getHelmetChances(), EquipmentSlot.HEAD);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getLeggingsChances(), EquipmentSlot.LEGS);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getBootsChances(), EquipmentSlot.FEET);
            }
            monster.m_20049_(SPAWNED_WITH_BACKPACK);
        });
    }

    private static void equipArmorPiece(Monster monster, Random rnd, int minDifficulty, List<WeightedElement<Item>> armorChances, EquipmentSlot slot) {
        RandHelper.getRandomWeightedElement(rnd, armorChances).ifPresent(armorPiece -> {
            if (armorPiece != Items.f_41852_) {
                ItemStack armorStack = new ItemStack((ItemLike)armorPiece);
                if (rnd.nextInt(6 - minDifficulty) == 0) {
                    float additionalDifficulty = monster.f_19853_.m_6436_(monster.m_142538_()).m_19057_();
                    int level = (int)(5.0f + additionalDifficulty * 18.0f + (float)(minDifficulty * 6));
                    EnchantmentHelper.m_44877_((Random)rnd, (ItemStack)armorStack, (int)level, (boolean)true);
                }
                monster.m_8061_(slot, armorStack);
            }
        });
    }

    private static void equipBackpack(Monster monster, ItemStack backpack, int difficulty, boolean playMusicDisc) {
        EntityBackpackAdditionHandler.getSpawnEgg(monster.m_6095_()).ifPresent(egg -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> {
            w.setColors(EntityBackpackAdditionHandler.getPrimaryColor(egg), EntityBackpackAdditionHandler.getSecondaryColor(egg));
            EntityBackpackAdditionHandler.setLoot(monster, w, difficulty);
            if (playMusicDisc) {
                w.getInventoryHandler();
                if (w.getUpgradeHandler().getSlots() > 0) {
                    monster.m_20049_(SPAWNED_WITH_JUKEBOX_UPGRADE);
                    EntityBackpackAdditionHandler.addJukeboxUpgradeAndRandomDisc(monster, w);
                }
            }
        }));
        monster.m_8061_(EquipmentSlot.CHEST, backpack);
        monster.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    private static void addJukeboxUpgradeAndRandomDisc(Monster monster, IBackpackWrapper w) {
        w.getUpgradeHandler().setStackInSlot(0, new ItemStack((ItemLike)ModItems.JUKEBOX_UPGRADE.get()));
        Iterator<JukeboxUpgradeItem.Wrapper> it = w.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).iterator();
        if (it.hasNext()) {
            JukeboxUpgradeItem.Wrapper wrapper = it.next();
            List<RecordItem> musicDiscs = EntityBackpackAdditionHandler.getMusicDiscs();
            wrapper.setDisc(new ItemStack((ItemLike)musicDiscs.get(monster.f_19853_.f_46441_.nextInt(musicDiscs.size()))));
        }
    }

    private static List<RecordItem> getMusicDiscs() {
        if (musicDiscs == null) {
            Map records = (Map)ObfuscationReflectionHelper.getPrivateValue(RecordItem.class, null, (String)"f_43032_");
            if (records == null) {
                musicDiscs = new ArrayList<RecordItem>();
            } else {
                HashSet blockedDiscs = new HashSet((Collection)Config.COMMON.entityBackpackAdditions.discBlockList.get());
                musicDiscs = new ArrayList<RecordItem>();
                records.forEach((sound, musicDisc) -> {
                    if (!blockedDiscs.contains(musicDisc.getRegistryName().toString())) {
                        musicDiscs.add((RecordItem)musicDisc);
                    }
                });
            }
        }
        return musicDiscs;
    }

    private static void raiseHealth(Monster monster, int minDifficulty) {
        if (Boolean.FALSE.equals(Config.COMMON.entityBackpackAdditions.buffHealth.get())) {
            return;
        }
        AttributeInstance maxHealth = monster.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            double healthAddition = maxHealth.m_22115_() * (double)minDifficulty;
            if (healthAddition > 0.1) {
                maxHealth.m_22125_(new AttributeModifier("Backpack bearer health bonus", healthAddition, AttributeModifier.Operation.ADDITION));
            }
            monster.m_21153_(monster.m_21233_());
        }
    }

    private static Optional<SpawnEggItem> getSpawnEgg(EntityType<?> entityType) {
        Map eggs = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"f_43201_");
        return eggs == null ? Optional.empty() : Optional.ofNullable((SpawnEggItem)eggs.get(entityType));
    }

    private static int getPrimaryColor(SpawnEggItem egg) {
        Integer primaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"f_151200_");
        return primaryColor == null ? -1 : primaryColor;
    }

    private static int getSecondaryColor(SpawnEggItem egg) {
        Integer secondaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"f_151201_");
        return secondaryColor == null ? -1 : secondaryColor;
    }

    private static void setLoot(Monster monster, IBackpackWrapper backpackWrapper, int difficulty) {
        MinecraftServer server = monster.f_19853_.m_142572_();
        if (server == null) {
            return;
        }
        if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.addLoot.get())) {
            EntityBackpackAdditionHandler.addLoot(monster, backpackWrapper, difficulty);
        }
    }

    private static void applyPotions(Monster monster, int difficulty, int minDifficulty) {
        if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.buffWithPotionEffects.get())) {
            RandHelper.getNRandomElements(APPLICABLE_EFFECTS, difficulty + 2).forEach(applicableEffect -> {
                int amplifier = Math.min(Math.max(minDifficulty, monster.f_19853_.f_46441_.nextInt(difficulty + 1)), applicableEffect.getMaxAmplifier());
                monster.m_7292_(new MobEffectInstance(applicableEffect.getEffect(), 36000, amplifier));
            });
        }
    }

    private static void addLoot(Monster monster, IBackpackWrapper backpackWrapper, int difficulty) {
        if (difficulty != 0) {
            Config.COMMON.entityBackpackAdditions.getLootTableName(monster.m_6095_()).ifPresent(lootTableName -> {
                float lootPercentage = (float)difficulty / 3.0f;
                backpackWrapper.setLoot((ResourceLocation)lootTableName, lootPercentage);
            });
        }
    }

    static void handleBackpackDrop(LivingDropsEvent event) {
        if (event.getEntity().m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            LivingEntity mob = event.getEntityLiving();
            ItemStack backpack = mob.m_6844_(EquipmentSlot.CHEST);
            if (event.getSource().m_7639_() instanceof Player && !(event.getSource().m_7639_() instanceof FakePlayer) && Math.max(mob.f_19853_.f_46441_.nextFloat() - (float)event.getLootingLevel() * 0.01f, 0.0f) < 0.085f) {
                ItemEntity backpackEntity = new ItemEntity(mob.f_19853_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), backpack);
                event.getDrops().add(backpackEntity);
            } else {
                EntityBackpackAdditionHandler.removeContentsUuid(backpack);
            }
        }
    }

    public static void removeBeneficialEffects(Creeper creeper) {
        if (creeper.m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            creeper.m_21220_().removeIf(e -> e.m_19544_().m_19486_());
        }
    }

    public static void removeBackpackUuid(Monster entity) {
        if (!entity.m_21224_() || !entity.m_19880_().contains(SPAWNED_WITH_BACKPACK)) {
            return;
        }
        ItemStack stack = entity.m_6844_(EquipmentSlot.CHEST);
        EntityBackpackAdditionHandler.removeContentsUuid(stack);
    }

    private static void removeContentsUuid(ItemStack stack) {
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getContentsUuid().ifPresent(uuid -> BackpackStorage.get().removeBackpackContents((UUID)uuid)));
    }

    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.m_19880_().contains(SPAWNED_WITH_JUKEBOX_UPGRADE)) {
            return;
        }
        entity.m_6844_(EquipmentSlot.CHEST).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).forEach(wrapper -> {
            if (wrapper.isPlaying()) {
                wrapper.tick(entity, entity.f_19853_, entity.m_142538_());
            } else {
                wrapper.play(entity);
            }
        }));
    }

    private static class ApplicableEffect {
        private final MobEffect effect;
        private final int maxAmplifier;

        private ApplicableEffect(MobEffect effect) {
            this(effect, Integer.MAX_VALUE);
        }

        private ApplicableEffect(MobEffect effect, int maxAmplifier) {
            this.effect = effect;
            this.maxAmplifier = maxAmplifier;
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getMaxAmplifier() {
            return this.maxAmplifier;
        }
    }

    private static class BackpackAddition {
        private final Item backpackItem;
        private final int minDifficulty;
        private final List<WeightedElement<Item>> helmetChances;
        private final List<WeightedElement<Item>> leggingsChances;
        private final List<WeightedElement<Item>> bootsChances;

        public List<WeightedElement<Item>> getHelmetChances() {
            return this.helmetChances;
        }

        public List<WeightedElement<Item>> getLeggingsChances() {
            return this.leggingsChances;
        }

        public List<WeightedElement<Item>> getBootsChances() {
            return this.bootsChances;
        }

        private BackpackAddition(Item backpackItem, int minDifficulty, List<WeightedElement<Item>> helmetChances, List<WeightedElement<Item>> leggingsChances, List<WeightedElement<Item>> bootsChances) {
            this.backpackItem = backpackItem;
            this.minDifficulty = minDifficulty;
            this.helmetChances = helmetChances;
            this.leggingsChances = leggingsChances;
            this.bootsChances = bootsChances;
        }

        public Item getBackpackItem() {
            return this.backpackItem;
        }

        public int getMinDifficulty() {
            return this.minDifficulty;
        }
    }
}

