/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackBackgroundProperties;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsContainer;

public class SettingsContainer
extends AbstractContainerMenu
implements IContextAwareContainer,
ISyncedContainer {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES;
    private final Player player;
    private final BackpackContext backpackContext;
    private final IBackpackWrapper backpackWrapper;
    private final BackpackBackgroundProperties backpackBackgroundProperties;
    private final List<Slot> backpackInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> ghostItemStacks = NonNullList.m_122779_();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    public final List<Slot> ghostSlots = new ArrayList<Slot>();
    private CompoundTag lastSettingsNbt = null;

    protected SettingsContainer(int windowId, Player player, BackpackContext backpackContext) {
        super((MenuType)ModItems.SETTINGS_CONTAINER_TYPE.get(), windowId);
        this.player = player;
        this.backpackContext = backpackContext;
        this.backpackWrapper = backpackContext.getBackpackWrapper(player);
        this.backpackBackgroundProperties = this.getNumberOfSlots() + this.backpackWrapper.getColumnsTaken() * this.backpackWrapper.getNumberOfSlotRows() <= 81 ? BackpackBackgroundProperties.REGULAR : BackpackBackgroundProperties.WIDE;
        this.addBackpackInventorySlots();
        this.addSettingsContainers();
    }

    private void addSettingsContainers() {
        BackpackSettingsHandler settingsHandler = this.backpackWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainer.instantiateContainer(this, name, category)));
    }

    private void addBackpackInventorySlots() {
        BackpackInventoryHandler inventoryHandler = this.backpackWrapper.getInventoryHandler();
        int slotIndex = 0;
        int yPosition = 18;
        while (slotIndex < inventoryHandler.getSlots()) {
            int lineIndex = slotIndex % this.getSlotsOnLine();
            int finalSlotIndex = slotIndex++;
            this.backpackInventorySlots.add(this.m_38897_((Slot)new ViewOnlyBackpackInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex, lineIndex, yPosition)));
            if (slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.ghostItemStacks.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public void m_38946_() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            ItemStack itemstack = this.ghostSlots.get(i).m_7993_();
            ItemStack itemstack1 = (ItemStack)this.ghostItemStacks.get(i);
            if (ItemStack.m_41728_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            boolean clientStackChanged = !itemstack1.equals(itemstack, true);
            ItemStack itemstack2 = itemstack.m_41777_();
            this.ghostItemStacks.set(i, (Object)itemstack2);
            if (!clientStackChanged) continue;
            for (ContainerListener icontainerlistener : this.f_38848_) {
                icontainerlistener.m_7934_((AbstractContainerMenu)this, i, itemstack2);
            }
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.backpackWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.backpackWrapper.getSettingsHandler().getNbt().m_6426_();
            this.sendBackpackSettingsToClient();
        }
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.f_19853_.f_46443_) {
            this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
                BackpackStorage storage = BackpackStorage.get();
                if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                    this.backpackWrapper.getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                }
            });
        }
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.f_19853_.f_46443_) {
            return;
        }
        this.backpackWrapper.getContentsUuid().ifPresent(uuid -> {
            CompoundTag settingsContents = new CompoundTag();
            CompoundTag settingsNbt = this.backpackWrapper.getSettingsHandler().getNbt();
            if (!settingsNbt.m_128456_()) {
                settingsContents.m_128365_("settings", (Tag)settingsNbt);
                PacketHandler.sendToClient((ServerPlayer)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
            }
        });
    }

    public void m_38893_(ContainerListener listener) {
        ContainerListener containerListener = listener;
        if (containerListener instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)containerListener;
            if (this.backpackWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
                super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.m_38893_(listener);
    }

    public Slot m_38853_(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public int getSlotsOnLine() {
        return this.backpackBackgroundProperties.getSlotsOnLine() - this.backpackWrapper.getColumnsTaken();
    }

    public int getNumberOfSlots() {
        return this.backpackWrapper.getInventoryHandler().getSlots();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    @Override
    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public List<Slot> getBackpackInventorySlots() {
        return this.backpackInventorySlots;
    }

    @Override
    public void handleMessage(CompoundTag data) {
        String categoryName;
        if (data.m_128441_("categoryName") && this.settingsContainers.containsKey(categoryName = data.m_128461_("categoryName"))) {
            this.settingsContainers.get(categoryName).handleMessage(data);
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public BackpackBackgroundProperties getBackpackBackgroundProperties() {
        return this.backpackBackgroundProperties;
    }

    public static SettingsContainer fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        return new SettingsContainer(windowId, playerInventory.f_35978_, BackpackContext.fromBuffer(packetBuffer));
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getNumberOfRows() {
        return this.backpackWrapper.getNumberOfSlotRows();
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(ImmutableMap.Builder<String, ISettingsContainerFactory<?, ?>> builder, String categoryName, ISettingsContainerFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainer settingsContainer, String name, C category) {
        return SettingsContainer.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        SettingsContainer.addFactory(builder, "backpack", BackpackSettingsContainer::new);
        SettingsContainer.addFactory(builder, "no_sort", NoSortSettingsContainer::new);
        SETTINGS_CONTAINER_FACTORIES = builder.build();
    }

    private static class ViewOnlyBackpackInventorySlot
    extends SlotItemHandler {
        public ViewOnlyBackpackInventorySlot(IItemHandler inventoryHandler, int slotIndex, int lineIndex, int yPosition) {
            super(inventoryHandler, slotIndex, 8 + lineIndex * 18, yPosition);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainer var1, String var2, C var3);
    }
}

