/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackOpenMessage {
    private final int subBackpackSlotIndex;

    public BackpackOpenMessage() {
        this(-1);
    }

    public BackpackOpenMessage(int subBackpackSlotIndex) {
        this.subBackpackSlotIndex = subBackpackSlotIndex;
    }

    public static void encode(BackpackOpenMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.subBackpackSlotIndex);
    }

    public static BackpackOpenMessage decode(FriendlyByteBuf packetBuffer) {
        return new BackpackOpenMessage(packetBuffer.readInt());
    }

    static void onMessage(BackpackOpenMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackOpenMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, BackpackOpenMessage msg) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackContainer) {
            BackpackContainer backpackContainer = (BackpackContainer)abstractContainerMenu;
            BackpackContext backpackContext = backpackContainer.getBackpackContext();
            if (msg.subBackpackSlotIndex == -1) {
                BackpackOpenMessage.openBackpack(player, backpackContext.getParentBackpackContext());
            } else {
                BackpackOpenMessage.openBackpack(player, backpackContext.getSubBackpackContext(msg.subBackpackSlotIndex));
            }
        } else {
            abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof IContextAwareContainer) {
                IContextAwareContainer contextAwareContainer = (IContextAwareContainer)abstractContainerMenu;
                BackpackOpenMessage.openBackpack(player, contextAwareContainer.getBackpackContext());
            } else {
                BackpackOpenMessage.findAndOpenFirstBackpack(player);
            }
        }
    }

    private static void findAndOpenFirstBackpack(ServerPlayer player) {
        PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, inventoryName, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, slot);
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.m_41786_()), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openBackpack(ServerPlayer player, BackpackContext backpackContext) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName((Player)player)), backpackContext::toBuffer);
    }
}

