/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ColorHelper;

public class ColorToggleButton
extends ButtonBase {
    private static final DyeColor[] DYE_VALUES = DyeColor.values();
    private static final List<FormattedText> TOOLTIP = new ImmutableList.Builder().add((Object)new TranslatableComponent(TranslationHelper.translSettingsButton("toggle_color"))).addAll(TranslationHelper.getTranslatedLines(TranslationHelper.translSettingsButton("toggle_color_detail"), null, ChatFormatting.GRAY)).build();
    private final Supplier<DyeColor> getColor;
    private final Consumer<DyeColor> setColor;

    public ColorToggleButton(Position position, Supplier<DyeColor> getColor, Consumer<DyeColor> setColor) {
        super(position, Dimension.SQUARE_18, (int b) -> {});
        this.getColor = getColor;
        this.setColor = setColor;
        this.setOnClick(this::onClick);
    }

    private void onClick(int button) {
        this.toggleColor(button);
    }

    private void toggleColor(int button) {
        if (button == 0) {
            this.setColor.accept(this.nextColor(this.getColor.get()));
        } else if (button == 1) {
            this.setColor.accept(this.previousColor(this.getColor.get()));
        }
    }

    private DyeColor nextColor(DyeColor color) {
        return DYE_VALUES[(color.ordinal() + 1) % DYE_VALUES.length];
    }

    private DyeColor previousColor(DyeColor color) {
        return DYE_VALUES[(color.ordinal() - 1 + DYE_VALUES.length) % DYE_VALUES.length];
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND);
        } else {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, GuiHelper.DEFAULT_BUTTON_BACKGROUND);
        }
    }

    @Override
    protected void renderWidget(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = ColorHelper.getColor(this.getColor.get().m_41068_()) | 0xC8000000;
        this.m_93179_(matrixStack, this.x + 3, this.y + 3, this.x + 15, this.y + 15, color, color);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
        if (this.m_5953_(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(TOOLTIP);
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

