/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;

public abstract class SettingsContainerBase<C extends ISettingsCategory> {
    private final SettingsContainer settingsContainer;
    private final String categoryName;
    private final C category;

    protected SettingsContainerBase(SettingsContainer settingsContainer, String categoryName, C category) {
        this.settingsContainer = settingsContainer;
        this.categoryName = categoryName;
        this.category = category;
    }

    protected C getCategory() {
        return this.category;
    }

    protected SettingsContainer getSettingsContainer() {
        return this.settingsContainer;
    }

    public void sendIntToServer(String key, int value) {
        this.sendDataToServer(() -> {
            CompoundTag data = new CompoundTag();
            data.m_128405_(key, value);
            return data;
        });
    }

    public void sendStringToServer(String key, String value) {
        this.sendDataToServer(() -> {
            CompoundTag data = new CompoundTag();
            data.m_128359_(key, value);
            return data;
        });
    }

    public void sendDataToServer(Supplier<CompoundTag> supplyData) {
        if (this.isServer()) {
            return;
        }
        CompoundTag data = supplyData.get();
        data.m_128359_("categoryName", this.categoryName);
        PacketHandler.sendToServer(new SyncContainerClientDataMessage(data));
    }

    protected boolean isServer() {
        return !this.settingsContainer.getPlayer().f_19853_.f_46443_;
    }

    public abstract void handleMessage(CompoundTag var1);
}

