/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogicBase {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;

    public FilterLogicBase(ItemStack upgrade, Consumer<ItemStack> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public void setAllowByDefault() {
        this.allowListDefault = true;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.m_41619_()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !stack.m_41720_().getRegistryName().m_135827_().equals(filter.m_41720_().getRegistryName().m_135827_()) : (primaryMatch == PrimaryMatch.ITEM ? !ItemStack.m_41746_((ItemStack)stack, (ItemStack)filter) : primaryMatch == PrimaryMatch.TAGS && !InventoryHelper.anyStackTagMatches(stack, filter))) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.m_41773_() != filter.m_41773_()) {
            return false;
        }
        return !this.shouldMatchNbt() || this.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    private boolean areItemStackTagsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA.m_41619_() && stackB.m_41619_()) {
            return true;
        }
        if (!stackA.m_41619_() && !stackB.m_41619_()) {
            if (stackA.m_41783_() == null && stackB.m_41783_() != null) {
                return false;
            }
            return (stackA.m_41783_() == null || this.areTagsEqualIgnoreDurability(stackA.m_41783_(), stackB.m_41783_())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    private boolean areTagsEqualIgnoreDurability(CompoundTag tagA, @Nullable CompoundTag tagB) {
        if (tagA == tagB) {
            return true;
        }
        if (tagB == null || tagA.m_128440_() != tagB.m_128440_()) {
            return false;
        }
        for (String key : tagA.m_128431_()) {
            if (!tagB.m_128441_(key)) {
                return false;
            }
            if (key.equals("Damage") || Objects.equals(tagA.m_128423_(key), tagB.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }
}

