/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeBackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;

public abstract class FilterLogicControlBase<F extends FilterLogicBase, S extends Slot, C extends FilterLogicContainerBase<F, S>>
extends CompositeBackpackWidget<BackpackWidget> {
    protected final Button[] showButtons;
    protected final int slotsTopYOffset;
    protected final int slotsPerRow;
    protected final int slotsInExtraRow;
    protected final int fullSlotRows;
    protected final C container;

    protected FilterLogicControlBase(C container, Position position, boolean buttonsVisible, int slotsPerRow, Button ... showButtons) {
        super(position, new Dimension(0, 0));
        this.container = container;
        this.slotsTopYOffset = buttonsVisible ? 21 : 0;
        this.slotsPerRow = slotsPerRow;
        this.showButtons = showButtons;
        if (this.shouldShow(Button.ALLOW_LIST)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x, this.y), ButtonDefinitions.ALLOW_LIST, button -> container.setAllowList(!container.isAllowList()), () -> container.isAllowList()));
        }
        if (this.shouldShow(Button.PRIMARY_MATCH)) {
            this.addChild(new ToggleButton<PrimaryMatch>(new Position(this.x + 18, this.y), ButtonDefinitions.PRIMARY_MATCH, button -> container.setPrimaryMatch(container.getPrimaryMatch().next()), () -> container.getPrimaryMatch()));
        }
        if (this.shouldShow(Button.DURABILITY)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x + 36, this.y), ButtonDefinitions.MATCH_DURABILITY, button -> container.setMatchDurability(!container.shouldMatchDurability()), () -> container.shouldMatchDurability()));
        }
        if (this.shouldShow(Button.NBT)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x + 54, this.y), ButtonDefinitions.MATCH_NBT, button -> container.setMatchNbt(!container.shouldMatchNbt()), () -> container.shouldMatchNbt()));
        }
        this.fullSlotRows = ((FilterLogicContainerBase)container).getFilterSlots().size() / slotsPerRow;
        this.slotsInExtraRow = ((FilterLogicContainerBase)container).getFilterSlots().size() % slotsPerRow;
        this.updateDimensions(Math.max(slotsPerRow * 18, this.getMaxButtonWidth()), (this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0)) * 18 + this.slotsTopYOffset);
    }

    protected int getMaxButtonWidth() {
        int maxWidth = 0;
        for (BackpackWidget w : this.children) {
            int buttonWidth = w.getX() + w.getWidth() - this.x;
            if (buttonWidth <= maxWidth) continue;
            maxWidth = buttonWidth;
        }
        return maxWidth;
    }

    protected boolean shouldShow(Button button) {
        for (Button showButton : this.showButtons) {
            if (showButton != button) continue;
            return true;
        }
        return false;
    }

    public void moveSlotsToView(int screenGuiLeft, int screenGuiTop) {
        int upgradeSlotNumber = 0;
        for (Slot slot : ((FilterLogicContainerBase)this.container).getFilterSlots()) {
            slot.f_40220_ = this.x - screenGuiLeft + 1 + upgradeSlotNumber % this.slotsPerRow * 18;
            slot.f_40221_ = this.y - screenGuiTop + this.slotsTopYOffset + 1 + upgradeSlotNumber / this.slotsPerRow * 18;
            ++upgradeSlotNumber;
        }
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x, this.y + this.slotsTopYOffset, this.slotsPerRow, this.fullSlotRows, this.slotsInExtraRow);
    }

    public static enum Button {
        ALLOW_LIST,
        PRIMARY_MATCH,
        DURABILITY,
        NBT;

    }
}

