/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class BatteryUpgradeWrapper
extends UpgradeWrapperBase<BatteryUpgradeWrapper, BatteryUpgradeItem>
implements IRenderedBatteryUpgrade,
IEnergyStorage,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final String ENERGY_STORED_TAG = "energyStored";
    private Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback;
    private final ItemStackHandler inventory;
    private int energyStored;

    protected BatteryUpgradeWrapper(IBackpackWrapper backpackWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                upgrade.m_41700_("inventory", (Tag)this.serializeNBT());
                BatteryUpgradeWrapper.this.save();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return this.isValidInputItem(stack);
                }
                if (slot == 1) {
                    return this.isValidOutputItem(stack);
                }
                return false;
            }

            private boolean isValidInputItem(ItemStack stack) {
                return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, false);
            }

            private boolean isValidOutputItem(ItemStack stack) {
                return BatteryUpgradeWrapper.this.isValidEnergyItem(stack, true);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        NBTHelper.getCompound(upgrade, "inventory").ifPresent(arg_0 -> ((ItemStackHandler)this.inventory).deserializeNBT(arg_0));
        this.energyStored = BatteryUpgradeWrapper.getEnergyStored(upgrade);
    }

    public static int getEnergyStored(ItemStack upgrade) {
        return NBTHelper.getInt(upgrade, ENERGY_STORED_TAG).orElse(0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.innerReceiveEnergy(maxReceive, simulate);
    }

    private int innerReceiveEnergy(int maxReceive, boolean simulate) {
        int ret = Math.min(this.getMaxEnergyStored() - this.energyStored, Math.min(this.getMaxInOut(), maxReceive));
        if (!simulate) {
            this.energyStored += ret;
            this.serializeEnergyStored();
        }
        return ret;
    }

    private void serializeEnergyStored() {
        NBTHelper.setInteger(this.upgrade, ENERGY_STORED_TAG, this.energyStored);
        this.save();
        this.forceUpdateBatteryRenderInfo();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.innerExtractEnergy(maxExtract, simulate);
    }

    private int innerExtractEnergy(int maxExtract, boolean simulate) {
        int ret = Math.min(this.energyStored, Math.min(this.getMaxInOut(), maxExtract));
        if (!simulate) {
            this.energyStored -= ret;
            this.serializeEnergyStored();
        }
        return ret;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return BatteryUpgradeWrapper.getMaxEnergyStored(this.backpackWrapper);
    }

    public static int getMaxEnergyStored(IBackpackWrapper backpackWrapper) {
        int maxEnergyBase;
        int stackMultiplier = BatteryUpgradeWrapper.getAdjustedStackMultiplier(backpackWrapper);
        return Integer.MAX_VALUE / stackMultiplier < (maxEnergyBase = BatteryUpgradeWrapper.getMaxEnergyBase(backpackWrapper)) ? Integer.MAX_VALUE : maxEnergyBase * stackMultiplier;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public static int getAdjustedStackMultiplier(IBackpackWrapper backpackWrapper) {
        return 1 + (int)((Double)Config.COMMON.batteryUpgrade.stackMultiplierRatio.get() * (double)(backpackWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    private static int getMaxEnergyBase(IBackpackWrapper backpackWrapper) {
        return (Integer)Config.COMMON.batteryUpgrade.energyPerSlotRow.get() * backpackWrapper.getNumberOfSlotRows();
    }

    private int getMaxInOut() {
        return (Integer)Config.COMMON.batteryUpgrade.maxInputOutput.get() * this.backpackWrapper.getNumberOfSlotRows() * BatteryUpgradeWrapper.getAdjustedStackMultiplier(this.backpackWrapper);
    }

    private boolean isValidEnergyItem(ItemStack stack, boolean isOutput) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyStorage -> isOutput || energyStorage.getEnergyStored() > 0).orElse(false);
    }

    @Override
    public void setBatteryRenderInfoUpdateCallback(Consumer<IRenderedBatteryUpgrade.BatteryRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateBatteryRenderInfo() {
        IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = new IRenderedBatteryUpgrade.BatteryRenderInfo(1.0f);
        batteryRenderInfo.setChargeRatio((float)Math.round((float)this.energyStored / (float)this.getMaxEnergyStored() * 4.0f) / 4.0f);
        this.updateTankRenderInfoCallback.accept(batteryRenderInfo);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.energyStored < this.getMaxEnergyStored()) {
            this.inventory.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY).ifPresent(this::receiveFromStorage);
        }
        if (this.energyStored > 0) {
            this.inventory.getStackInSlot(1).getCapability(CapabilityEnergy.ENERGY).ifPresent(this::extractToStorage);
        }
    }

    private void extractToStorage(IEnergyStorage energyStorage) {
        int toExtract = this.innerExtractEnergy(this.getMaxInOut(), true);
        if (toExtract > 0 && (toExtract = energyStorage.receiveEnergy(toExtract, true)) > 0) {
            energyStorage.receiveEnergy(toExtract, false);
            this.innerExtractEnergy(toExtract, false);
        }
    }

    private void receiveFromStorage(IEnergyStorage energyStorage) {
        int toReceive = this.innerReceiveEnergy(this.getMaxInOut(), true);
        if (toReceive > 0 && (toReceive = energyStorage.extractEnergy(toReceive, true)) > 0) {
            energyStorage.extractEnergy(toReceive, false);
            this.innerReceiveEnergy(toReceive, false);
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.energyStored / (float)BatteryUpgradeWrapper.getMaxEnergyBase(this.backpackWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }
}

