/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.filter;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IIOFilterUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.filter.Direction;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.filter.FilterUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterUpgradeWrapper
extends UpgradeWrapperBase<FilterUpgradeWrapper, FilterUpgradeItem>
implements IFilteredUpgrade,
IIOFilterUpgrade {
    private final FilterLogic filterLogic;

    public FilterUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FilterUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    public void setDirection(Direction direction) {
        NBTHelper.setEnumConstant(this.upgrade, "direction", direction);
        this.save();
        this.backpackWrapper.refreshInventoryForInputOutput();
    }

    public Direction getDirection() {
        return NBTHelper.getEnumConstant(this.upgrade, "direction", Direction::fromName).orElse(Direction.BOTH);
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public Optional<FilterLogic> getInputFilter() {
        Direction direction = this.getDirection();
        return direction == Direction.INPUT || direction == Direction.BOTH ? Optional.of(this.getFilterLogic()) : Optional.empty();
    }

    @Override
    public Optional<FilterLogic> getOutputFilter() {
        Direction direction = this.getDirection();
        return direction == Direction.OUTPUT || direction == Direction.BOTH ? Optional.of(this.getFilterLogic()) : Optional.empty();
    }
}

