/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.StopDiscPlaybackMessage;

public class ServerBackpackSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<ResourceKey<Level>, Long> lastWorldCheck = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Map<UUID, KeepAliveInfo>> worldBackpackKeepAlive = new HashMap<ResourceKey<Level>, Map<UUID, KeepAliveInfo>>();

    private ServerBackpackSoundHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ServerBackpackSoundHandler::tick);
    }

    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.world.m_5776_()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.world;
        ResourceKey dim = world.m_46472_();
        if (lastWorldCheck.computeIfAbsent((ResourceKey<Level>)dim, key -> world.m_46467_()) > world.m_46467_() - 10L || !worldBackpackKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((ResourceKey<Level>)dim, world.m_46467_());
        worldBackpackKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < world.m_46467_() - 10L) {
                ServerBackpackSoundHandler.sendStopMessage(world, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID backpackUuid, Level world, Vec3 position, Runnable onNoLongerRunning) {
        ResourceKey dim = world.m_46472_();
        if (!worldBackpackKeepAlive.containsKey(dim) || !worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            worldBackpackKeepAlive.get(dim).get(backpackUuid).update(world.m_46467_(), position);
        }
    }

    public static void onSoundStopped(ServerLevel world, UUID backpackUuid) {
        ServerBackpackSoundHandler.removeKeepAliveInfo(world, backpackUuid);
    }

    public static void startPlayingDisc(ServerLevel serverWorld, BlockPos position, UUID backpackUuid, int discItemId, Runnable onStopHandler) {
        Vec3 pos = Vec3.m_82512_((Vec3i)position);
        PacketHandler.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), pos, 128, new PlayDiscMessage(backpackUuid, discItemId, position));
        ServerBackpackSoundHandler.putKeepAliveInfo(serverWorld, backpackUuid, onStopHandler, pos);
    }

    public static void startPlayingDisc(ServerLevel serverWorld, Vec3 position, UUID backpackUuid, int entityId, int discItemId, Runnable onStopHandler) {
        PacketHandler.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), position, 128, new PlayDiscMessage(backpackUuid, discItemId, entityId));
        ServerBackpackSoundHandler.putKeepAliveInfo(serverWorld, backpackUuid, onStopHandler, position);
    }

    private static void putKeepAliveInfo(ServerLevel serverWorld, UUID backpackUuid, Runnable onStopHandler, Vec3 pos) {
        worldBackpackKeepAlive.computeIfAbsent((ResourceKey<Level>)serverWorld.m_46472_(), dim -> new HashMap()).put(backpackUuid, new KeepAliveInfo(onStopHandler, serverWorld.m_46467_(), pos));
    }

    public static void stopPlayingDisc(ServerLevel serverWorld, Vec3 position, UUID backpackUuid) {
        ServerBackpackSoundHandler.removeKeepAliveInfo(serverWorld, backpackUuid);
        ServerBackpackSoundHandler.sendStopMessage(serverWorld, position, backpackUuid);
    }

    private static void removeKeepAliveInfo(ServerLevel serverWorld, UUID backpackUuid) {
        ResourceKey dim = serverWorld.m_46472_();
        if (worldBackpackKeepAlive.containsKey(dim) && worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            worldBackpackKeepAlive.get(dim).remove(backpackUuid).runOnStop();
        }
    }

    private static void sendStopMessage(ServerLevel serverWorld, Vec3 position, UUID backpackUuid) {
        PacketHandler.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), position, 128, new StopDiscPlaybackMessage(backpackUuid));
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onStopHandler;
        private long lastKeepAliveTime;
        private Vec3 lastPosition;

        private KeepAliveInfo(Runnable onStopHandler, long lastKeepAliveTime, Vec3 lastPosition) {
            this.onStopHandler = new WeakReference<Runnable>(onStopHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vec3 getLastPosition() {
            return this.lastPosition;
        }

        public void update(long gameTime, Vec3 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnStop() {
            Runnable handler = (Runnable)this.onStopHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

