/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int BACKPACK_FILTER_REFRESH_COOLDOWN_TICKS = 10;
    private static final int COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private long backpackContentsRefreshCooldown = 0L;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        List itemEntities = world.m_142425_((EntityTypeTest)EntityType.f_20461_, new AABB(pos).m_82400_((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            this.setCooldown(world, 10);
            return;
        }
        int cooldown = 40;
        if (this.backpackContentsRefreshCooldown < world.m_46467_()) {
            this.backpackContentsRefreshCooldown = world.m_46467_() + 10L;
            this.filterLogic.refreshBackpackFilterStacks((IItemHandler)this.backpackWrapper.getInventoryForUpgradeProcessing());
        }
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.m_6084_() || !this.filterLogic.matchesFilter(itemEntity.m_32055_()) || this.canNotPickup(itemEntity, entity) || !this.tryToInsertItem(itemEntity)) continue;
            cooldown = 10;
        }
        this.setCooldown(world, cooldown);
    }

    private boolean isBlockedBySomething(ItemEntity itemEntity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(itemEntity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(ItemEntity itemEntity, @Nullable LivingEntity player) {
        if (this.isBlockedBySomething(itemEntity)) {
            return true;
        }
        CompoundTag data = itemEntity.getPersistentData();
        return player != null ? data.m_128441_(PREVENT_REMOTE_MOVEMENT) : data.m_128441_(PREVENT_REMOTE_MOVEMENT) && !data.m_128441_(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        IItemHandlerModifiable inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        ItemStack remaining = InventoryHelper.insertIntoInventory(stack, (IItemHandler)inventory, true);
        boolean insertedSomething = false;
        if (remaining.m_41613_() != stack.m_41613_()) {
            insertedSomething = true;
            remaining = InventoryHelper.insertIntoInventory(stack, (IItemHandler)inventory, false);
            itemEntity.m_32045_(remaining);
        }
        return insertedSomething;
    }
}

